/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.job;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;

public class JobListQuery
extends AbstractLazyLoadingQuery {
    protected transient ManagementService managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();

    @Override
    public int size() {
        return (int)this.managementService.createJobQuery().count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List jobs = ((JobQuery)((JobQuery)this.managementService.createJobQuery().orderByJobDuedate().asc()).orderByJobId().asc()).list();
        ArrayList<Item> items = new ArrayList<Item>();
        for (Job job : jobs) {
            items.add((Item)new JobListItem(job));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        Job job = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
        if (job != null) {
            return new JobListItem(job);
        }
        return null;
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    class JobListItem
    extends PropertysetItem
    implements Comparable<JobListItem> {
        private static final long serialVersionUID = 1L;

        public JobListItem(Job job) {
            this.addItemProperty("id", (Property)new ObjectProperty((Object)job.getId(), String.class));
            this.addItemProperty("dueDate", (Property)new ObjectProperty((Object)job.getDuedate(), Date.class));
            this.addItemProperty("name", (Property)new ObjectProperty((Object)this.getName(job), String.class));
        }

        private String getName(Job theJob) {
            if (theJob instanceof TimerEntity) {
                return "Timer job " + theJob.getId();
            }
            if (theJob instanceof MessageEntity) {
                return "Message job " + theJob.getId();
            }
            return "Job " + theJob.getId();
        }

        @Override
        public int compareTo(JobListItem other) {
            Date otherDueDate;
            Date dueDate = (Date)this.getItemProperty("dueDate").getValue();
            int comparison = this.compareObjects(dueDate, otherDueDate = (Date)other.getItemProperty("dueDate").getValue());
            if (comparison != 0) {
                return comparison;
            }
            String id = (String)this.getItemProperty("id").getValue();
            String otherId = (String)other.getItemProperty("id").getValue();
            return id.compareTo(otherId);
        }

        private <T> int compareObjects(Comparable<T> object, Comparable<T> other) {
            if (object != null) {
                if (other != null) {
                    return object.compareTo(other);
                }
                return 1;
            }
            if (other == null) {
                return 0;
            }
            return -1;
        }
    }
}

