/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.Application;
import com.vaadin.event.MouseEvents;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.InputStream;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.Images;

public class UserDetailsComponent
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected ViewManager viewManager;
    protected User user;
    protected String skypeId;
    protected String role;
    protected String buttonCaption;
    protected Button.ClickListener clickListener;

    public UserDetailsComponent(String userId, String role) {
        this.role = role;
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.viewManager = ExplorerApp.get().getViewManager();
        if (userId != null) {
            this.user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
            this.skypeId = this.identityService.getUserInfo(userId, "skype");
        }
    }

    public UserDetailsComponent(String userId, String role, String buttonCaption, Button.ClickListener clickListener) {
        this(userId, role);
        this.buttonCaption = buttonCaption;
        this.clickListener = clickListener;
    }

    public void attach() {
        super.attach();
        this.setSpacing(true);
        this.addUserPicture();
        this.addUserDetails();
    }

    protected void addUserPicture() {
        Picture userPicture;
        Resource pictureResource = Images.USER_32;
        if (this.user != null && (userPicture = this.identityService.getUserPicture(this.user.getId())) != null) {
            pictureResource = new StreamResource(new StreamResource.StreamSource(){

                public InputStream getStream() {
                    return userPicture.getInputStream();
                }
            }, this.user.getId(), (Application)ExplorerApp.get());
        }
        Embedded picture = new Embedded(null, pictureResource);
        picture.setType(1);
        picture.addStyleName("task-event-picture");
        if (this.user != null) {
            picture.setHeight("32px");
            picture.setWidth("32px");
        }
        this.addComponent((Component)picture);
        if (this.user != null) {
            picture.addStyleName("clickable");
            picture.addListener(new MouseEvents.ClickListener(){

                public void click(MouseEvents.ClickEvent event) {
                    UserDetailsComponent.this.viewManager.showProfilePopup(UserDetailsComponent.this.user.getId());
                }
            });
        }
    }

    protected void addUserDetails() {
        VerticalLayout detailsLayout = new VerticalLayout();
        this.addComponent((Component)detailsLayout);
        HorizontalLayout nameLayout = new HorizontalLayout();
        nameLayout.setSpacing(true);
        detailsLayout.addComponent((Component)nameLayout);
        Label nameLabel = null;
        if (this.user != null) {
            nameLabel = new Label(this.user.getFirstName() + " " + this.user.getLastName());
            nameLabel.addStyleName("bold");
        } else {
            nameLabel = new Label("&nbsp;", 3);
        }
        nameLayout.addComponent((Component)nameLabel);
        HorizontalLayout actionsLayout = new HorizontalLayout();
        actionsLayout.setSpacing(true);
        detailsLayout.addComponent((Component)actionsLayout);
        Label roleLabel = new Label(this.role);
        actionsLayout.addComponent((Component)roleLabel);
        if (this.clickListener != null) {
            Button button = new Button(this.buttonCaption);
            button.addStyleName("small");
            button.addListener(this.clickListener);
            actionsLayout.addComponent((Component)button);
        }
    }
}

