/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerEntity
extends JobEntity {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TimerEntity.class);
    protected int maxIterations;
    protected String repeat;
    protected Date endDate;

    public TimerEntity() {
        this.jobType = "timer";
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.jobHandlerType = timerDeclaration.getJobHandlerType();
        this.jobHandlerConfiguration = timerDeclaration.getJobHandlerConfiguration();
        this.isExclusive = timerDeclaration.isExclusive();
        this.repeat = timerDeclaration.getRepeat();
        this.retries = timerDeclaration.getRetries();
        this.jobType = "timer";
    }

    private TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.retries = te.retries;
        this.endDate = te.endDate;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
        this.processDefinitionId = te.processDefinitionId;
        this.tenantId = te.tenantId;
        this.jobType = "timer";
    }

    @Override
    public void execute(CommandContext commandContext) {
        int repeatValue;
        this.restoreExtraData(commandContext, this.jobHandlerConfiguration);
        if (this.getDuedate() != null && !this.isValidTime(this.getDuedate())) {
            if (log.isDebugEnabled()) {
                log.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)this.getId());
            }
            this.delete();
            return;
        }
        super.execute(commandContext);
        if (log.isDebugEnabled()) {
            log.debug("Timer {} fired. Deleting timer.", (Object)this.getId());
        }
        this.delete();
        if (this.repeat != null && (repeatValue = this.calculateRepeatValue()) != 0) {
            Date newTimer;
            if (repeatValue > 0) {
                this.setNewRepeat(repeatValue);
            }
            if ((newTimer = this.calculateNextTimer()) != null && this.isValidTime(newTimer)) {
                TimerEntity te = new TimerEntity(this);
                te.setDuedate(newTimer);
                Context.getCommandContext().getJobEntityManager().schedule(te);
            }
        }
    }

    private void restoreExtraData(CommandContext commandContext, String jobHandlerConfiguration) {
        String embededActivityId = jobHandlerConfiguration;
        if (this.jobHandlerType.equalsIgnoreCase("timer-transition") || this.jobHandlerType.equalsIgnoreCase("timer-intermediate-transition") || this.jobHandlerType.equalsIgnoreCase("timer-start-event")) {
            embededActivityId = TimerEventHandler.getActivityIdFromConfiguration(jobHandlerConfiguration);
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(jobHandlerConfiguration);
            if (endDateExpressionString != null) {
                Expression endDateExpression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
                VariableScope executionEntity = null;
                if (this.executionId != null) {
                    executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
                }
                if (executionEntity == null) {
                    executionEntity = NoExecutionVariableScope.getSharedInstance();
                }
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue(executionEntity);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        this.endDate = (Date)endDateValue;
                    } else {
                        throw new ActivitiException("Timer '" + ((ExecutionEntity)executionEntity).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (this.endDate == null) {
                        this.endDate = businessCalendar.resolveEndDate(endDateString);
                    }
                }
            }
        }
        if (this.processDefinitionId != null) {
            ProcessDefinition def = Context.getProcessEngineConfiguration().getRepositoryService().getProcessDefinition(this.processDefinitionId);
            this.maxIterations = this.checkStartEventDefinitions(def, embededActivityId);
            if (this.maxIterations <= 1) {
                this.maxIterations = this.checkBoundaryEventsDefinitions(def, embededActivityId);
            }
        } else {
            this.maxIterations = 1;
        }
    }

    private int checkStartEventDefinitions(ProcessDefinition def, String embededActivityId) {
        List startTimerDeclarations = (List)((ProcessDefinitionEntity)def).getProperty("timerStart");
        if (startTimerDeclarations != null && startTimerDeclarations.size() > 0) {
            TimerDeclarationImpl timerDeclaration = (TimerDeclarationImpl)startTimerDeclarations.get(0);
            String definitionActivityId = TimerEventHandler.getActivityIdFromConfiguration(timerDeclaration.getJobHandlerConfiguration());
            if (timerDeclaration.getJobHandlerType().equalsIgnoreCase(this.jobHandlerType) && definitionActivityId.equalsIgnoreCase(embededActivityId)) {
                return this.calculateMaxIterationsValue(timerDeclaration.getDescription().getExpressionText());
            }
        }
        return 1;
    }

    private int checkBoundaryEventsDefinitions(ProcessDefinition def, String embededActivityId) {
        List<ActivityImpl> activities = ((ProcessDefinitionEntity)def).getActivities();
        for (ActivityImpl activity : activities) {
            List activityTimerDeclarations = (List)activity.getProperty("timerDeclarations");
            if (activityTimerDeclarations == null) continue;
            for (TimerDeclarationImpl timerDeclaration : activityTimerDeclarations) {
                String definitionActivityId = TimerEventHandler.getActivityIdFromConfiguration(timerDeclaration.getJobHandlerConfiguration());
                if (!timerDeclaration.getJobHandlerType().equalsIgnoreCase(this.jobHandlerType) || !definitionActivityId.equalsIgnoreCase(embededActivityId)) continue;
                return this.calculateMaxIterationsValue(timerDeclaration.getDescription().getExpressionText());
            }
        }
        return 1;
    }

    private int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R")) {
            times = Integer.MAX_VALUE;
            if (expression.get(0).length() > 1) {
                times = Integer.parseInt(expression.get(0).substring(1));
            }
        }
        return times;
    }

    private boolean isValidTime(Date newTimer) {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.validateDuedate(this.repeat, this.maxIterations, this.endDate, newTimer);
    }

    private int calculateRepeatValue() {
        int times = -1;
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    private void setNewRepeat(int newRepeatValue) {
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append("/");
            repeatBuilder.append(value);
        }
        this.repeat = repeatBuilder.toString();
    }

    private Date calculateNextTimer() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(this.repeat, this.maxIterations);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

