/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.List;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.pvm.runtime.StartingExecution;

public class AtomicOperationProcessStartInitial
extends AbstractEventAtomicOperation {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        StartingExecution startingExecution = execution.getStartingExecution();
        if (activity == startingExecution.getInitial()) {
            execution.disposeStartingExecution();
            execution.performOperation(ACTIVITY_EXECUTE);
        } else {
            List<ActivityImpl> initialActivityStack = processDefinition.getInitialActivityStack(startingExecution.getInitial());
            int index = initialActivityStack.indexOf(activity);
            activity = initialActivityStack.get(index + 1);
            InterpretableExecution executionToUse = null;
            executionToUse = activity.isScope() ? (InterpretableExecution)execution.getExecutions().get(0) : execution;
            executionToUse.setActivity(activity);
            executionToUse.performOperation(PROCESS_START_INITIAL);
        }
    }
}

