/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.context;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.activiti.cdi.ActivitiCdiException;
import org.activiti.cdi.impl.context.ContextAssociationManager;
import org.activiti.cdi.impl.util.ProgrammaticBeanLookup;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextAssociationManager
implements ContextAssociationManager,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DefaultContextAssociationManager.class);
    @Inject
    private BeanManager beanManager;

    protected Class<? extends ScopedAssociation> getBroadestActiveContext() {
        for (Class<? extends ScopedAssociation> scopeType : this.getAvailableScopedAssociationClasses()) {
            Annotation scopeAnnotation;
            Annotation annotation = scopeAnnotation = scopeType.getAnnotations().length > 0 ? scopeType.getAnnotations()[0] : null;
            if (scopeAnnotation == null || !this.beanManager.isScope(scopeAnnotation.annotationType())) {
                throw new ActivitiException("ScopedAssociation must carry exactly one annotation and it must be a @Scope annotation");
            }
            try {
                this.beanManager.getContext(scopeAnnotation.annotationType());
                return scopeType;
            }
            catch (ContextNotActiveException e) {
                log.trace("Context {} not active.", scopeAnnotation.annotationType());
            }
        }
        throw new ActivitiException("Could not determine an active context to associate the current process instance / task instance with.");
    }

    protected List<Class<? extends ScopedAssociation>> getAvailableScopedAssociationClasses() {
        ArrayList<Class<? extends ScopedAssociation>> scopeTypes = new ArrayList<Class<? extends ScopedAssociation>>();
        scopeTypes.add(ConversationScopedAssociation.class);
        scopeTypes.add(RequestScopedAssociation.class);
        return scopeTypes;
    }

    protected ScopedAssociation getScopedAssociation() {
        return ProgrammaticBeanLookup.lookup(this.getBroadestActiveContext(), this.beanManager);
    }

    @Override
    public void setExecution(Execution execution) {
        if (execution == null) {
            throw new ActivitiCdiException("Cannot associate with execution: null");
        }
        if (Context.getCommandContext() != null) {
            throw new ActivitiCdiException("Cannot work with scoped associations inside command context.");
        }
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        Execution associatedExecution = scopedAssociation.getExecution();
        if (associatedExecution != null && !associatedExecution.getId().equals(execution.getId())) {
            throw new ActivitiCdiException("Cannot associate " + execution + ", already associated with " + associatedExecution + ". Disassociate first!");
        }
        if (log.isTraceEnabled()) {
            log.trace("Associating {} (@{})", (Object)execution, (Object)scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName());
        }
        scopedAssociation.setExecution(execution);
    }

    @Override
    public void disAssociate() {
        if (Context.getCommandContext() != null) {
            throw new ActivitiCdiException("Cannot work with scoped associations inside command context.");
        }
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        if (scopedAssociation.getExecution() == null) {
            throw new ActivitiException("Cannot dissasociate execution, no " + scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName() + " execution associated. ");
        }
        if (log.isTraceEnabled()) {
            log.trace("Disassociating");
        }
        scopedAssociation.setExecution(null);
        scopedAssociation.setTask(null);
    }

    @Override
    public String getExecutionId() {
        Execution execution = this.getExecution();
        if (execution != null) {
            return execution.getId();
        }
        return null;
    }

    @Override
    public Execution getExecution() {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution;
        }
        return this.getScopedAssociation().getExecution();
    }

    @Override
    public Object getVariable(String variableName) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution.getVariable(variableName);
        }
        return this.getScopedAssociation().getVariable(variableName);
    }

    @Override
    public void setVariable(String variableName, Object value) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            execution.setVariable(variableName, value);
            execution.getVariable(variableName);
        } else {
            this.getScopedAssociation().setVariable(variableName, value);
        }
    }

    protected ExecutionEntity getExecutionFromContext() {
        ExecutionContext executionContext;
        if (Context.getCommandContext() != null && (executionContext = Context.getExecutionContext()) != null) {
            return executionContext.getExecution();
        }
        return null;
    }

    @Override
    public Task getTask() {
        if (Context.getCommandContext() != null) {
            throw new ActivitiCdiException("Cannot work with tasks in an activiti command.");
        }
        return this.getScopedAssociation().getTask();
    }

    @Override
    public void setTask(Task task) {
        if (Context.getCommandContext() != null) {
            throw new ActivitiCdiException("Cannot work with tasks in an activiti command.");
        }
        this.getScopedAssociation().setTask(task);
    }

    @Override
    public Map<String, Object> getCachedVariables() {
        if (Context.getCommandContext() != null) {
            throw new ActivitiCdiException("Cannot work with cached variables in an activiti command.");
        }
        return this.getScopedAssociation().getCachedVariables();
    }

    @RequestScoped
    protected static class RequestScopedAssociation
    extends ScopedAssociation
    implements Serializable {
        protected RequestScopedAssociation() {
        }
    }

    @ConversationScoped
    protected static class ConversationScopedAssociation
    extends ScopedAssociation
    implements Serializable {
        protected ConversationScopedAssociation() {
        }
    }

    protected static class ScopedAssociation {
        @Inject
        private RuntimeService runtimeService;
        protected Map<String, Object> cachedVariables = new HashMap<String, Object>();
        protected Execution execution;
        protected Task task;

        protected ScopedAssociation() {
        }

        public Execution getExecution() {
            return this.execution;
        }

        public void setExecution(Execution execution) {
            this.execution = execution;
        }

        public Task getTask() {
            return this.task;
        }

        public void setTask(Task task) {
            this.task = task;
        }

        public <T> T getVariable(String variableName) {
            Object value = this.cachedVariables.get(variableName);
            if (value == null && this.execution != null) {
                value = this.runtimeService.getVariable(this.execution.getId(), variableName);
                this.cachedVariables.put(variableName, value);
            }
            return (T)value;
        }

        public void setVariable(String variableName, Object value) {
            this.cachedVariables.put(variableName, value);
        }

        public Map<String, Object> getCachedVariables() {
            return this.cachedVariables;
        }
    }
}

