/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.activiti.crystalball.simulator.EventCalendar;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.runtime.ClockReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventCalendar
implements EventCalendar {
    private static Logger log = LoggerFactory.getLogger((String)SimpleEventCalendar.class.getName());
    private static final int NULL = -1;
    protected List<SimulationEvent> eventList = new ArrayList<SimulationEvent>();
    protected int minIndex = -1;
    protected Comparator<SimulationEvent> eventComparator;
    protected final ClockReader clockReader;

    public SimpleEventCalendar(ClockReader clockReader, Comparator<SimulationEvent> eventComparator) {
        this.clockReader = clockReader;
        this.eventComparator = eventComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.minIndex == -1;
    }

    @Override
    public SimulationEvent peekFirstEvent() {
        if (this.minIndex == -1) {
            return null;
        }
        return this.eventList.get(this.minIndex);
    }

    @Override
    public SimulationEvent removeFirstEvent() {
        if (this.minIndex == -1) {
            return null;
        }
        SimulationEvent minEvent = this.eventList.remove(this.minIndex);
        if (minEvent.hasSimulationTime() && minEvent.getSimulationTime() < this.clockReader.getCurrentTime().getTime()) {
            throw new ActivitiException("Unable to execute event from the past");
        }
        if (this.eventList.isEmpty()) {
            this.minIndex = -1;
        } else {
            this.minIndex = 0;
            SimulationEvent event = this.eventList.get(0);
            for (int i = 1; i < this.eventList.size(); ++i) {
                if (this.eventComparator.compare(this.eventList.get(i), event) >= 0) continue;
                this.minIndex = i;
                event = this.eventList.get(i);
            }
        }
        return minEvent;
    }

    @Override
    public List<SimulationEvent> getEvents() {
        return this.eventList;
    }

    @Override
    public void addEvent(SimulationEvent event) {
        log.debug("Scheduling new event [{}]", (Object)event);
        if (event != null && this.isMinimal(event)) {
            this.minIndex = this.eventList.size();
        }
        this.eventList.add(event);
    }

    @Override
    public void clear() {
        this.eventList.clear();
        this.minIndex = -1;
    }

    private boolean isMinimal(SimulationEvent event) {
        return this.minIndex == -1 || this.eventComparator.compare(event, this.eventList.get(this.minIndex)) < 0;
    }

    public void addEvents(Collection<SimulationEvent> simulationEvents) {
        for (SimulationEvent event : simulationEvents) {
            this.addEvent(event);
        }
    }
}

