/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupIdentityManager;
import org.activiti.ldap.LDAPCallBack;
import org.activiti.ldap.LDAPConfigurator;
import org.activiti.ldap.LDAPGroupCache;
import org.activiti.ldap.LDAPTemplate;

public class LDAPGroupManager
extends AbstractManager
implements GroupIdentityManager {
    protected LDAPConfigurator ldapConfigurator;
    protected LDAPGroupCache ldapGroupCache;

    public LDAPGroupManager(LDAPConfigurator ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public LDAPGroupManager(LDAPConfigurator ldapConfigurator, LDAPGroupCache ldapGroupCache) {
        this.ldapConfigurator = ldapConfigurator;
        this.ldapGroupCache = ldapGroupCache;
    }

    public Group createNewGroup(String groupId) {
        throw new ActivitiException("LDAP group manager doesn't support creating a new group");
    }

    public void insertGroup(Group group) {
        throw new ActivitiException("LDAP group manager doesn't support inserting a group");
    }

    public void updateGroup(Group updatedGroup) {
        throw new ActivitiException("LDAP group manager doesn't support updating a group");
    }

    public boolean isNewGroup(Group group) {
        throw new ActivitiException("LDAP group manager doesn't support inserting or updating a group");
    }

    public void deleteGroup(String groupId) {
        throw new ActivitiException("LDAP group manager doesn't support deleting a group");
    }

    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutor());
    }

    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        if (query.getUserId() != null) {
            return this.findGroupsByUser(query.getUserId());
        }
        throw new ActivitiIllegalArgumentException("This query is not supported by the LDAPGroupManager");
    }

    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return this.findGroupByQueryCriteria(query, null).size();
    }

    public List<Group> findGroupsByUser(final String userId) {
        List<Group> groups;
        if (this.ldapGroupCache != null && (groups = this.ldapGroupCache.get(userId)) != null) {
            return groups;
        }
        LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
        return ldapTemplate.execute(new LDAPCallBack<List<Group>>(){

            @Override
            public List<Group> executeInContext(InitialDirContext initialDirContext) {
                String searchExpression = LDAPGroupManager.this.ldapConfigurator.getLdapQueryBuilder().buildQueryGroupsForUser(LDAPGroupManager.this.ldapConfigurator, userId);
                ArrayList<Group> groups = new ArrayList<Group>();
                try {
                    String baseDn = LDAPGroupManager.this.ldapConfigurator.getGroupBaseDn() != null ? LDAPGroupManager.this.ldapConfigurator.getGroupBaseDn() : LDAPGroupManager.this.ldapConfigurator.getBaseDn();
                    NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPGroupManager.this.createSearchControls());
                    while (namingEnum.hasMore()) {
                        SearchResult result = namingEnum.next();
                        GroupEntity group = new GroupEntity();
                        if (LDAPGroupManager.this.ldapConfigurator.getGroupIdAttribute() != null) {
                            group.setId(result.getAttributes().get(LDAPGroupManager.this.ldapConfigurator.getGroupIdAttribute()).get().toString());
                        }
                        if (LDAPGroupManager.this.ldapConfigurator.getGroupNameAttribute() != null) {
                            group.setName(result.getAttributes().get(LDAPGroupManager.this.ldapConfigurator.getGroupNameAttribute()).get().toString());
                        }
                        if (LDAPGroupManager.this.ldapConfigurator.getGroupTypeAttribute() != null) {
                            group.setType(result.getAttributes().get(LDAPGroupManager.this.ldapConfigurator.getGroupTypeAttribute()).get().toString());
                        }
                        groups.add((Group)group);
                    }
                    namingEnum.close();
                    if (LDAPGroupManager.this.ldapGroupCache != null) {
                        LDAPGroupManager.this.ldapGroupCache.add(userId, groups);
                    }
                    return groups;
                }
                catch (NamingException e) {
                    throw new ActivitiException("Could not find groups for user " + userId, (Throwable)e);
                }
            }
        });
    }

    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        throw new ActivitiException("LDAP group manager doesn't support querying");
    }

    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        throw new ActivitiException("LDAP group manager doesn't support querying");
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

