/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.persistence.entity.GroupIdentityManager;
import org.activiti.engine.runtime.ClockReader;
import org.activiti.ldap.LDAPConfigurator;
import org.activiti.ldap.LDAPGroupCache;
import org.activiti.ldap.LDAPGroupManager;

public class LDAPGroupManagerFactory
implements SessionFactory {
    protected LDAPConfigurator ldapConfigurator;
    protected LDAPGroupCache ldapGroupCache;
    protected LDAPGroupCache.LDAPGroupCacheListener ldapCacheListener;

    public LDAPGroupManagerFactory(LDAPConfigurator ldapConfigurator, ClockReader clockReader) {
        this.ldapConfigurator = ldapConfigurator;
        if (ldapConfigurator.getGroupCacheSize() > 0) {
            this.ldapGroupCache = new LDAPGroupCache(ldapConfigurator.getGroupCacheSize(), ldapConfigurator.getGroupCacheExpirationTime(), clockReader);
            if (this.ldapCacheListener != null) {
                this.ldapGroupCache.setLdapCacheListener(this.ldapCacheListener);
            }
        }
    }

    public Class<?> getSessionType() {
        return GroupIdentityManager.class;
    }

    public Session openSession() {
        if (this.ldapGroupCache == null) {
            return new LDAPGroupManager(this.ldapConfigurator);
        }
        return new LDAPGroupManager(this.ldapConfigurator, this.ldapGroupCache);
    }

    public LDAPConfigurator getLdapConfigurator() {
        return this.ldapConfigurator;
    }

    public void setLdapConfigurator(LDAPConfigurator ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public LDAPGroupCache getLdapGroupCache() {
        return this.ldapGroupCache;
    }

    public void setLdapGroupCache(LDAPGroupCache ldapGroupCache) {
        this.ldapGroupCache = ldapGroupCache;
    }

    public LDAPGroupCache.LDAPGroupCacheListener getLdapCacheListener() {
        return this.ldapCacheListener;
    }

    public void setLdapCacheListener(LDAPGroupCache.LDAPGroupCacheListener ldapCacheListener) {
        this.ldapCacheListener = ldapCacheListener;
    }
}

