/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import javax.naming.directory.InitialDirContext;
import org.activiti.ldap.LDAPCallBack;
import org.activiti.ldap.LDAPConfigurator;
import org.activiti.ldap.LDAPConnectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPTemplate.class);
    protected LDAPConfigurator ldapConfigurator;

    public LDAPTemplate(LDAPConfigurator ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public <T> T execute(LDAPCallBack<T> ldapCallBack) {
        InitialDirContext initialDirContext = null;
        try {
            initialDirContext = LDAPConnectionUtil.creatDirectoryContext(this.ldapConfigurator);
        }
        catch (Exception e) {
            LOGGER.info("Could not create LDAP connection : " + e.getMessage(), (Throwable)e);
        }
        T result = ldapCallBack.executeInContext(initialDirContext);
        LDAPConnectionUtil.closeDirectoryContext(initialDirContext);
        return result;
    }

    public LDAPConfigurator getLdapConfigurator() {
        return this.ldapConfigurator;
    }

    public void setLdapConfigurator(LDAPConfigurator ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }
}

