﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Drawing;

namespace ColorPicker
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {

			Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
			{
				ColorPickerDialog dlg = new ColorPickerDialog();
				dlg.SetBasicColors(new ColorPickerDialog.ColorItem[] {
					new ColorPickerDialog.ColorItem{Index =   "1", RGB = Color.White},
					new ColorPickerDialog.ColorItem{Index =   "2", RGB = Color.Black},
					new ColorPickerDialog.ColorItem{Index =   "3", RGB = Color.Yellow},
					new ColorPickerDialog.ColorItem{Index =   "4", RGB = Color.Blue},
					new ColorPickerDialog.ColorItem{Index =   "5", RGB = Color.Green},
					new ColorPickerDialog.ColorItem{Index =   "6", RGB = Color.Purple},
					new ColorPickerDialog.ColorItem{Index =   "7", RGB = Color.Pink},
					new ColorPickerDialog.ColorItem{Index =   "8", RGB = Color.Magenta},
					new ColorPickerDialog.ColorItem{Index =   "9", RGB = Color.Maroon},
					new ColorPickerDialog.ColorItem{Index =  "10", RGB = Color.MediumBlue},
					new ColorPickerDialog.ColorItem{Index =  "11", RGB = Color.Cyan},
					new ColorPickerDialog.ColorItem{Index =  "12", RGB = Color.MediumSeaGreen},
					new ColorPickerDialog.ColorItem{Index =  "13", RGB = Color.DimGray},
					new ColorPickerDialog.ColorItem{Index = "140", RGB = Color.LightCoral},
				});
				for (int i = 0; i < 3; ++i) {
					if (i == 1) dlg.EnableCustomColors = false;
					else if (i == 2) dlg.EnableCustomColors = true;
					DialogResult dr = dlg.ShowDialog();
					if (dr == DialogResult.OK) {
						MessageBox.Show(string.Format("OK {0}:{1}", dlg.Current.Index, dlg.Current.RGB));
					} else {
						MessageBox.Show(string.Format("cancel"));
					}
				}
			};
			ColorPickerDialog frm = new ColorPickerDialog();
			var tm = new Timer();
			tm.Tick += (object sender, EventArgs e) => {
				frm.SetBasicColors(new ColorPickerDialog.ColorItem[] {
					new ColorPickerDialog.ColorItem{Index =   "1", RGB = Color.White},
					new ColorPickerDialog.ColorItem{Index =   "2", RGB = Color.Black},
					new ColorPickerDialog.ColorItem{Index =   "3", RGB = Color.Yellow},
					new ColorPickerDialog.ColorItem{Index =  "10", RGB = Color.MediumBlue},
					new ColorPickerDialog.ColorItem{Index =  "11", RGB = Color.Cyan},
					new ColorPickerDialog.ColorItem{Index =  "13", RGB = Color.DimGray},
					new ColorPickerDialog.ColorItem{Index = "140", RGB = Color.LightCoral},
				});
				tm.Stop();
			};
			tm.Interval = 2000;
			tm.Start();

			Application.Run(frm);
        }
    }
}
