﻿// Copyright (C) 2017  Mocchi (mocchi_2003@yahoo.co.jp)
// License: Boost Software License   See LICENSE.txt for the full license.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace pdf_pp {
	public partial class DividePDFForm : UserControl {
		public string InputPDFFileName {
			get {
				return textBox_filename.Text;
			}
			set {
				textBox_filename.Text = InputPDFFileName;
			}
		}
		public DividePDFForm() {
			InitializeComponent();
		}

		private void ChangeCreateButtonState() {
			button_create.Enabled = false;
			Program.MainForm.Status = "";
			if (!File.Exists(textBox_filename.Text)) return;
			int idmy;
			if (!int.TryParse(textBox_div_horz.Text, out idmy) || idmy <= 0) return;
			if (!int.TryParse(textBox_div_vert.Text, out idmy) || idmy <= 0) return;
			double ddmy;
			if (!double.TryParse(textBox_margin.Text, out ddmy)) return;
			button_create.Enabled = true;
			Program.MainForm.Status = "Ready.";
		}
		private void textBox_TextChanged(object sender, EventArgs e) {
			ChangeCreateButtonState();
		}

		private void button_browse_Click(object sender, EventArgs e) {
			OpenFileDialog ofn = new OpenFileDialog();
			ofn.Filter = "PDF Files (*.pdf)|*.pdf";
			ofn.FilterIndex = 0;
			if (ofn.ShowDialog() == DialogResult.OK) {
				textBox_filename.Text = ofn.FileName;
			}
		}

		private void button_create_Click(object sender, EventArgs e) {
			int xdiv = int.Parse(textBox_div_horz.Text), ydiv = int.Parse(textBox_div_vert.Text);
			double margin = double.Parse(textBox_margin.Text) * 0.01;
			string pdf_path = textBox_filename.Text;
			string pdf_dir = Path.GetDirectoryName(pdf_path), pdf_name = Path.GetFileNameWithoutExtension(pdf_path);
			try {
				Program.CreateSplittedPDF(pdf_path, Path.Combine(pdf_dir, pdf_name + string.Format("_{0}x{1}.pdf", xdiv, ydiv)), null, xdiv, ydiv, margin);
				Program.MainForm.Status = "Finished.";
			} catch (Exception ex) {
				Program.MainForm.Status = "Error: " + ex.Message;
			}
		}
	}
}
