/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCMARSHAL_H_
#define IPCMARSHAL_H_

#ifdef	IPC_MARSHAL_MAIN
#define	extern
#endif	/* IPC_MARSHAL_MAIN */

#include	<features.h>
#include	<endian.h>
#include	<ieee754.h>
#include	<arpa/inet.h>

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcShm.h"
#include	"rpcMsg.h"

#if !defined(__LITTLE_ENDIAN__) && !defined(__BIG_ENDIAN__) 
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define __LITTLE_ENDIAN__
#elif __BYTE_ORDER == __BIG_ENDIAN
#define __BIG_ENDIAN__
#endif
#endif

#define	IPC_SHM_MARSHAL_GAP_SIZE				0

extern RpcResult_t IPC_InitMarshal(RpcBool_t masterProcess);
extern RpcResult_t IPC_Marshal(RpcParamData_t *inData, void **outData, uint32_t *outSize);
extern RpcResult_t IPC_Unmarshal(void *inData, uint32_t inSzie, void *outData, uint32_t outSize);
extern void IPC_FreeMarshaledSharedData(void *data);
extern uint32_t IPC_GetMarshaledDataSize(void *data);
extern void *IPC_DuplicateMarshaledData(void *marshaledData,uint32_t marshaledDataSize);

extern void IPC_SetMsgParam(RpcMsgParam_t *msgParam,uint32_t funcId,uint32_t pId,uint32_t queId,uint32_t seqNum,uint32_t extData,void* extParam);

#endif /* IPCMARSHAL_H_ */
