/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger;

import android.app.Activity;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import org.routine_work.simple_battery_logger.db.BatteryHistoryDBHelper;
import org.routine_work.simple_battery_logger.service.DeleteAllDataService;
import org.routine_work.utils.Log;

public class DeleteAllDataActivity extends Activity implements OnClickListener
{

	public static final String LOG_TAG = "simple-battery-logger";

	/**
	 * Called when the activity is first created.
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.delete_all_data_activity);

		Button okButton = (Button) findViewById(R.id.ok_button);
		okButton.setOnClickListener(this);
		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);

		int batteryHistoryDataCount = getBatteryHistoryDataCount();
		if (batteryHistoryDataCount == 0)
		{
			okButton.setVisibility(View.GONE);
		}
		else
		{
			String confirmMessage = getString(R.string.delete_data_confirm_message, batteryHistoryDataCount);
			Log.d(LOG_TAG, "confirmMessage => " + confirmMessage);
			TextView confirmMessageTextView = (TextView) findViewById(R.id.delete_data_confirm_message_textview);
			confirmMessageTextView.setText(confirmMessage);
		}
	}

	@Override
	public void onClick(View view)
	{
		int id = view.getId();
		switch (id)
		{
			case R.id.ok_button:
				deleteAllData();
				setResult(RESULT_OK);
				finish();
				break;
			case R.id.cancel_button:
				finish();
				setResult(RESULT_CANCELED);
				break;
		}
	}

	private void deleteAllData()
	{
		Intent intent = new Intent(this, DeleteAllDataService.class);
		startService(intent);
	}

	private int getBatteryHistoryDataCount()
	{
		int dataCount = -1;

		BatteryHistoryDBHelper dbHelper = new BatteryHistoryDBHelper(this);
		SQLiteDatabase db = dbHelper.getReadableDatabase();
		if (db != null)
		{
			try
			{
				dataCount = dbHelper.getBatteryHistoryCount(db);
			}
			finally
			{
				db.close();
			}
		}

		return dataCount;
	}
}
