/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCSHM_H_
#define IPCSHM_H_

#include	<sys/mman.h>
#include	<sys/stat.h>
#include	<fcntl.h>

#ifdef	IPC_SHM_MAIN
#define	extern
#endif	/* IPC_SHM_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcSyscall.h"

#define	IPC_SHARED_MEM_NUM			(3)

#define	IPC_SHARED_MEM_MANAGE_AREA_SIZE		(1024*10)	/* 10KB FOR HEADER */

#define	IPC_MARSHAL_SHARED_MEM_SIZE		(IPC_MARSHAL_SHARED_MEM_REAL_SIZE + IPC_SHARED_MEM_MANAGE_AREA_SIZE)
#define	IPC_DATABASE_SHARED_MEM_SIZE		(IPC_DATABASE_SHARED_REAL_MEM_SIZE + IPC_SHARED_MEM_MANAGE_AREA_SIZE)
#define	IPC_MSG_QUE_SHARED_MEM_SIZE		(IPC_MSG_QUE_SHARED_REAL_MEM_SIZE + IPC_SHARED_MEM_MANAGE_AREA_SIZE)

#define	IPC_CHECK_ALIGNMENT			(0x7)
#define	IPC_ALIGNMENT_UP			(0x8)
#define	IPC_ALIGNMENT_CUT			(0xFFFFFFF8)
#define	IPC_ALIGNMENT(a)			(((a)&IPC_CHECK_ALIGNMENT)?(((a)&IPC_ALIGNMENT_CUT)+IPC_ALIGNMENT_UP):(a))

extern RpcResult_t IPC_InitSharedMem(RpcBool_t masterProcess);
extern RpcResult_t IPC_DestroySharedMem(void);
extern RpcResult_t IPC_AttachSharedMem(void);
extern RpcResult_t IPC_DettachSharedMem(void);
extern RpcResult_t IPC_GetShmInfo(char *name, int32_t *fd, void **addr, uint32_t *size);
extern RpcResult_t IPC_InitShmGapArea(int fd, uint32_t gapSize);
extern RpcResult_t IPC_GetShmGapData(int fd,void **startArea, uint32_t *gapSize);

extern RpcResult_t IPC_InitShmAllocArea(int fd, uint32_t memSize, uint32_t numOfDev, uint32_t minSize, uint32_t rateOfMagnify);
extern void *IPC_AllocShmMem(int fd, uint32_t size);
extern void IPC_FreeShmMem(int fd, void *addr);
extern uint32_t IPC_AllocatedSizeShmMem(int fd, void *addr);
extern void *IPC_ReallocShmMem(int fd, void *addr, uint32_t newSize);
//extern void *IPC_AllcShmMemWithTimeout(int fd, uint32_t size, uint32_t timeout);
//extern void *IPC_ReallocShmMemWithTimeout(int fd, void *addr, uint32_t newSize, uint32_t timeout);

#endif /* IPCSHM_H_ */
