/*
 * IPRPC - Inter Process Remote Procedure Call
 *
* Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCSKELTON_H_
#define IPCSKELTON_H_

#ifdef	IPC_SKELTON_MAIN
#define	extern
#endif	/* IPC_SKELTON_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"

typedef RpcResult_t (*IPC_SkeltonFunc_t)(uint32_t processId, uint32_t seqNum, void *inData ,uint32_t inSize, void **outData, int32_t *outSize, uint32_t timeOut);
typedef RpcResult_t (*IPC_SkeltonCancelFunc_t)(uint32_t processId, uint32_t seqNum);

//extern RpcResult_t IPC_InitSkelton(IpcProcessType_t processType);
extern RpcResult_t IPC_InitSkelton(RpcBool_t masterProcess);
//extern RpcResult_t IPC_SkeltonRegisterFunction(uint32_t funcId,uint16_t accessDevice, uint16_t accessProcess,IPC_SkeltonFunc_t func,IPC_SkeltonCancelFunc_t cancelFunc);
extern RpcResult_t IPC_SkeltonRegisterFunction(uint32_t funcId,IPC_SkeltonFunc_t func,IPC_SkeltonCancelFunc_t cancelFunc);
extern RpcResult_t IPC_SkeltonUnregisterFunction(uint32_t funcId);

#endif /* IPCSKLTON_H_ */
