/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientMessageListener;
import jp.syuriken.snsw.twclient.ClientTab;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.filter.MessageFilter;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;

public class FilterService
implements ClientMessageListener {
    protected final ClientConfiguration configuration;
    protected final ArrayList<MessageFilter> filterList;
    protected final ReentrantReadWriteLock filterListLock;
    protected final List<ClientTab> tabsList;
    protected final ReentrantReadWriteLock tabsListLock;
    private CacheManager cacheManager;

    public FilterService(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.cacheManager = configuration.getCacheManager();
        this.filterList = new ArrayList();
        this.filterListLock = new ReentrantReadWriteLock();
        this.tabsList = configuration.getFrameTabs();
        this.tabsListLock = configuration.getFrameTabsLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(MessageFilter messageFilter) {
        try {
            this.filterListLock.writeLock().lock();
            this.filterList.add(messageFilter);
        }
        finally {
            this.filterListLock.writeLock().unlock();
        }
    }

    protected void addJob(Runnable runnable) {
        this.configuration.addJob(runnable);
    }

    protected void filter(FilterDispatcher filterDispatcher) {
        this.addJob(filterDispatcher);
    }

    private Status getTwitterStatus(Status originalStatus) {
        TwitterStatus status;
        if (originalStatus instanceof TwitterStatus) {
            return originalStatus;
        }
        Status cachedStatus = this.cacheManager.getCachedStatus(originalStatus.getId());
        if (cachedStatus == null && (cachedStatus = this.cacheManager.cacheStatusIfAbsent(status = new TwitterStatus(this.configuration, originalStatus))) == null) {
            cachedStatus = status;
        }
        return cachedStatus;
    }

    public void onBlock(User source, User blockedUser) {
    }

    @Override
    public void onChangeAccount(final boolean forWrite) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onChangeAccount(forWrite);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onChangeAccount(forWrite);
            }
        });
    }

    public void onCleanUp() {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onStreamCleanUp();
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onCleanUp();
            }
        });
    }

    @Override
    public void onClientMessage(final String name, final Object arg) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onClientMessage(name, arg);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onClientMessage(name, arg);
            }
        });
    }

    public void onConnect() {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onStreamConnect();
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onConnect();
            }
        });
    }

    public void onDeletionNotice(final long directMessageId, final long userId) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onDeletionNotice(directMessageId, userId);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onDeletionNotice(directMessageId, userId);
            }
        });
    }

    public void onDeletionNotice(final StatusDeletionNotice statusDeletionNotice) {
        this.filter(new FilterDispatcher(){
            private StatusDeletionNotice obj;
            {
                this.obj = statusDeletionNotice;
            }

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                this.obj = messageFilter.onDeletionNotice(this.obj);
                return this.obj == null;
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onDeletionNotice(this.obj);
            }
        });
    }

    public void onDirectMessage(final DirectMessage directMessage) {
        this.filter(new FilterDispatcher(){
            private DirectMessage message;
            {
                this.message = directMessage;
            }

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                this.message = messageFilter.onDirectMessage(this.message);
                return this.message == null;
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onDirectMessage(this.message);
            }
        });
    }

    public void onDisconnect() {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onStreamDisconnect();
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onDisconnect();
            }
        });
    }

    public void onException(final Exception ex) {
        this.filter(new FilterDispatcher(){
            private Exception obj;
            {
                this.obj = ex;
            }

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onException(this.obj);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onException(this.obj);
            }
        });
    }

    public void onFavorite(final User source, final User target, final Status favoritedStatus) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onFavorite(source, target, favoritedStatus);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onFavorite(source, target, favoritedStatus);
            }
        });
    }

    public void onFollow(final User source, final User followedUser) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onFollow(source, followedUser);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onFollow(source, followedUser);
            }
        });
    }

    public void onFriendList(final long[] friendIds) {
        this.filter(new FilterDispatcher(){
            long[] arr;
            {
                this.arr = friendIds;
            }

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                this.arr = messageFilter.onFriendList(this.arr);
                return this.arr == null || this.arr.length == 0;
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onFriendList(this.arr);
            }
        });
    }

    public void onScrubGeo(final long userId, final long upToStatusId) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onScrubGeo(userId, upToStatusId);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onScrubGeo(userId, upToStatusId);
            }
        });
    }

    public void onStallWarning(final StallWarning warning) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onStallWarning(warning);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onStallWarning(warning);
            }
        });
    }

    public void onStatus(Status originalStatus) {
        final Status status = this.getTwitterStatus(originalStatus);
        this.filter(new FilterDispatcher(){
            private Status obj;
            {
                this.obj = status;
            }

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                this.obj = messageFilter.onStatus(this.obj);
                return this.obj == null;
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onStatus(this.obj);
            }
        });
    }

    public void onTrackLimitationNotice(final int numberOfLimitedStatuses) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onTrackLimitationNotice(numberOfLimitedStatuses);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onTrackLimitationNotice(numberOfLimitedStatuses);
            }
        });
    }

    public void onUnblock(final User source, final User unblockedUser) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUnblock(source, unblockedUser);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUnblock(source, unblockedUser);
            }
        });
    }

    public void onUnfavorite(final User source, final User target, final Status unfavoritedStatus) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUnfavorite(source, target, unfavoritedStatus);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUnfavorite(source, target, unfavoritedStatus);
            }
        });
    }

    public void onUserListCreation(final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListCreation(listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListCreation(listOwner, list);
            }
        });
    }

    public void onUserListDeletion(final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListDeletion(listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListDeletion(listOwner, list);
            }
        });
    }

    public void onUserListMemberAddition(final User addedMember, final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListMemberAddition(addedMember, listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListMemberAddition(addedMember, listOwner, list);
            }
        });
    }

    public void onUserListMemberDeletion(final User deletedMember, final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListMemberDeletion(deletedMember, listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListMemberDeletion(deletedMember, listOwner, list);
            }
        });
    }

    public void onUserListSubscription(final User subscriber, final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListSubscription(subscriber, listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListSubscription(subscriber, listOwner, list);
            }
        });
    }

    public void onUserListUnsubscription(final User subscriber, final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListUnsubscription(subscriber, listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListUnsubscription(subscriber, listOwner, list);
            }
        });
    }

    public void onUserListUpdate(final User listOwner, final UserList list) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserListUpdate(listOwner, list);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserListUpdate(listOwner, list);
            }
        });
    }

    public void onUserProfileUpdate(final User updatedUser) {
        this.filter(new FilterDispatcher(){

            @Override
            protected boolean callDispatch(MessageFilter messageFilter) {
                return messageFilter.onUserProfileUpdate(updatedUser);
            }

            @Override
            protected void notifyClientMessage(ClientMessageListener notifyListener) {
                notifyListener.onUserProfileUpdate(updatedUser);
            }
        });
    }

    public abstract class FilterDispatcher
    implements ParallelRunnable {
        protected abstract boolean callDispatch(MessageFilter var1);

        public void dispatch() {
            MessageFilter messageFilter;
            FilterService.this.filterListLock.readLock().lock();
            boolean isFiltered = false;
            Iterator<Object> i$ = FilterService.this.filterList.iterator();
            while (i$.hasNext() && !(isFiltered = this.callDispatch(messageFilter = i$.next()))) {
            }
            FilterService.this.filterListLock.readLock().unlock();
            if (!isFiltered) {
                FilterService.this.tabsListLock.readLock().lock();
                for (ClientTab tab : FilterService.this.tabsList) {
                    this.notifyClientMessage(tab.getRenderer());
                }
                FilterService.this.tabsListLock.readLock().unlock();
            }
        }

        protected abstract void notifyClientMessage(ClientMessageListener var1);

        @Override
        public void run() {
            this.dispatch();
        }
    }
}

