/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.TwitterExtendedObject;
import jp.syuriken.snsw.twclient.TwitterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.User;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.DataObjectFactory;

public class TwitterUser
implements User,
TwitterExtendedObject {
    private static final long serialVersionUID = -345155522353480502L;
    private static final Logger logger = LoggerFactory.getLogger(TwitterUser.class);
    private final Date createdAt;
    private final long id;
    private final boolean isContributorsEnabled;
    private final boolean isFollowRequestSent;
    private final boolean isGeoEnabled;
    private final boolean isVerified;
    private final String lang;
    private final String profileBackgroundColor;
    private final boolean profileBackgroundTiled;
    private final String profileLinkColor;
    private final String profileSidebarBorderColor;
    private final String profileSidebarFillColor;
    private final String profileTextColor;
    private boolean profileUseBackgroundImage;
    private final boolean showAllInlineMedia;
    private final String timeZone;
    private final boolean translator;
    private final int utcOffset;
    private String description;
    private int favouritesCount;
    private int followersCount;
    private int friendsCount;
    private boolean isProtected;
    private int listedCount;
    private String location;
    private String name;
    private String screenName;
    private Status status;
    private int statusesCount;
    private String url;
    private String profileBackgroundImageUrl;
    private String profileBackgroundImageUrlHttps;
    private String profileImageUrl;
    private String profileImageUrlHttps;
    private final String json;
    private String profileBannerImageUrl;

    private static JSONObject getJsonObject(ClientConfiguration configuration, User originalUser) throws AssertionError {
        String json = DataObjectFactory.getRawJSON((Object)originalUser);
        JSONObject jsonObject = null;
        if (json != null) {
            try {
                jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                logger.error("Cannot parse json", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        return jsonObject;
    }

    public TwitterUser(ClientConfiguration configuration, User originalUser) {
        this(configuration, originalUser, TwitterUser.getJsonObject(configuration, originalUser));
    }

    public TwitterUser(ClientConfiguration configuration, User originalUser, JSONObject jsonObject) {
        CacheManager cacheManager;
        Status cachedStatus;
        JSONObject statusJsonObject;
        this.createdAt = originalUser.getCreatedAt();
        this.id = originalUser.getId();
        this.isContributorsEnabled = originalUser.isContributorsEnabled();
        this.isFollowRequestSent = originalUser.isFollowRequestSent();
        this.isGeoEnabled = originalUser.isGeoEnabled();
        this.isVerified = originalUser.isVerified();
        this.lang = originalUser.getLang();
        this.url = originalUser.getURL();
        this.profileBackgroundColor = originalUser.getProfileBackgroundColor();
        this.profileBackgroundImageUrl = originalUser.getProfileBackgroundImageURL();
        this.profileBackgroundImageUrlHttps = originalUser.getProfileBackgroundImageUrlHttps();
        this.profileBackgroundTiled = originalUser.isProfileBackgroundTiled();
        this.profileImageUrl = originalUser.getProfileImageURL();
        this.profileImageUrlHttps = originalUser.getProfileImageURLHttps();
        this.profileLinkColor = originalUser.getProfileLinkColor();
        this.profileSidebarBorderColor = originalUser.getProfileSidebarBorderColor();
        this.profileSidebarFillColor = originalUser.getProfileSidebarFillColor();
        this.profileTextColor = originalUser.getProfileTextColor();
        this.profileUseBackgroundImage = originalUser.isProfileUseBackgroundImage();
        this.showAllInlineMedia = originalUser.isShowAllInlineMedia();
        this.timeZone = originalUser.getTimeZone();
        this.translator = originalUser.isTranslator();
        this.utcOffset = originalUser.getUtcOffset();
        this.description = originalUser.getDescription();
        this.favouritesCount = originalUser.getFavouritesCount();
        this.followersCount = originalUser.getFollowersCount();
        this.friendsCount = originalUser.getFriendsCount();
        this.isProtected = originalUser.isProtected();
        this.listedCount = originalUser.getListedCount();
        this.location = originalUser.getLocation();
        this.name = originalUser.getName();
        this.screenName = originalUser.getScreenName();
        this.statusesCount = originalUser.getStatusesCount();
        this.profileBannerImageUrl = originalUser.getProfileBannerURL();
        this.json = jsonObject == null ? null : jsonObject.toString();
        Status status = originalUser.getStatus();
        try {
            statusJsonObject = jsonObject == null ? null : (jsonObject.isNull("status") ? null : jsonObject.getJSONObject("status"));
        }
        catch (JSONException e) {
            logger.error("Cannot parse json", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (status != null && !(status instanceof TwitterStatus) && (cachedStatus = (cacheManager = configuration.getCacheManager()).getCachedStatus(status.getId())) == null && (cachedStatus = cacheManager.cacheStatusIfAbsent(status = new TwitterStatus(configuration, status, statusJsonObject))) != null) {
            status = cachedStatus;
        }
        this.status = status;
    }

    public int compareTo(User b) {
        long thisId = this.id;
        long thatId = b.getId();
        if (thisId < thatId) {
            return -1;
        }
        if (thisId > thatId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        return ((User)obj).getId() == this.id;
    }

    public int getAccessLevel() {
        return -1;
    }

    public String getBiggerProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_bigger");
    }

    public String getBiggerProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_bigger");
    }

    public Date getCreatedAt() {
        return (Date)this.createdAt.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getJson() {
        return this.json;
    }

    public String getLang() {
        return this.lang;
    }

    public int getListedCount() {
        return this.listedCount;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMiniProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_mini");
    }

    public String getMiniProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_mini");
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "");
    }

    public String getOriginalProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "");
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    @Deprecated
    @SuppressWarnings(value={"NM_CONFUSING"})
    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    @SuppressWarnings(value={"NM_CONFUSING"})
    public String getProfileBackgroundImageURL() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundImageUrlHttps() {
        return this.profileBackgroundImageUrlHttps;
    }

    public String getProfileBannerIPadRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad_retina" : null;
    }

    public String getProfileBannerIPadURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad" : null;
    }

    public String getProfileBannerMobileRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad_retina" : null;
    }

    public String getProfileBannerMobileURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/mobile" : null;
    }

    public String getProfileBannerRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web_retina" : null;
    }

    public String getProfileBannerURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web" : null;
    }

    public String getProfileImageURL() {
        return this.profileImageUrl;
    }

    @Deprecated
    public URL getProfileImageUrlHttps() {
        try {
            return new URL(this.profileImageUrlHttps);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getProfileImageURLHttps() {
        return this.profileImageUrlHttps;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public RateLimitStatus getRateLimitStatus() {
        return null;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getURL() {
        return this.url;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean isContributorsEnabled() {
        return this.isContributorsEnabled;
    }

    public boolean isFollowRequestSent() {
        return this.isFollowRequestSent;
    }

    public boolean isGeoEnabled() {
        return this.isGeoEnabled;
    }

    public boolean isProfileBackgroundTiled() {
        return this.profileBackgroundTiled;
    }

    public boolean isProfileUseBackgroundImage() {
        return this.profileUseBackgroundImage;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isShowAllInlineMedia() {
        return this.showAllInlineMedia;
    }

    public boolean isTranslator() {
        return this.translator;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    private String toResizedURL(String originalURL, String sizeSuffix) {
        if (null != originalURL) {
            int index = originalURL.lastIndexOf("_");
            int suffixIndex = originalURL.lastIndexOf(".");
            return originalURL.substring(0, index) + sizeSuffix + originalURL.substring(suffixIndex);
        }
        return null;
    }

    public void updateUser(User user) throws IllegalArgumentException {
        if (this.id != user.getId()) {
            throw new IllegalArgumentException("UserID\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        this.description = user.getDescription();
        this.favouritesCount = user.getFavouritesCount();
        this.followersCount = user.getFollowersCount();
        this.friendsCount = user.getFriendsCount();
        this.listedCount = user.getListedCount();
        this.location = user.getLocation();
        this.name = user.getName();
        this.profileBackgroundImageUrl = user.getProfileBackgroundImageURL();
        this.profileBackgroundImageUrlHttps = user.getProfileBackgroundImageUrlHttps();
        this.profileImageUrl = user.getProfileImageURL();
        this.profileImageUrlHttps = user.getProfileImageURLHttps();
        this.isProtected = user.isProtected();
        this.screenName = user.getScreenName();
        this.status = user.getStatus();
        this.statusesCount = user.getStatusesCount();
        this.url = user.getURL();
    }
}

