/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.config;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.config.ConfigFrameBuilder;

public class ConfigFrame
extends JFrame {
    static ConfigFrame openingFrame;
    private static Object staticHolder;
    final ClientProperties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JFrame build(ConfigFrameBuilder.Config[] configs, ClientConfiguration configuration) {
        Object object = staticHolder;
        synchronized (object) {
            if (openingFrame != null) {
                return openingFrame;
            }
            openingFrame = new ConfigFrame(configuration);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        openingFrame.add(tabbedPane);
        ClientProperties properties = configuration.getConfigProperties();
        String group = "UNDEF";
        String subgroup = "UNDEF";
        JPanel tabContent = null;
        JPanel subgroupPanel = null;
        GroupLayout layout = null;
        GroupLayout.SequentialGroup verticalGroup = null;
        GroupLayout.ParallelGroup horizontalNameGroup = null;
        GroupLayout.ParallelGroup horizontalValueGroup = null;
        GroupLayout.ParallelGroup horizontalCombinedGroup = null;
        for (ConfigFrameBuilder.Config config : configs) {
            if (!group.equals(config.getGroup())) {
                group = config.getGroup();
                tabContent = new JPanel();
                tabContent.setLayout(new BoxLayout(tabContent, 1));
                subgroup = "UNDEF";
                tabbedPane.add(group, new JScrollPane(tabContent));
            }
            if (subgroup == null ? config.getSubgroup() != null : !subgroup.equals(config.getSubgroup())) {
                subgroup = config.getSubgroup();
                subgroupPanel = new JPanel();
                layout = new GroupLayout(subgroupPanel);
                subgroupPanel.setLayout(layout);
                verticalGroup = layout.createSequentialGroup();
                horizontalNameGroup = layout.createParallelGroup();
                horizontalValueGroup = layout.createParallelGroup();
                horizontalCombinedGroup = layout.createParallelGroup();
                layout.setVerticalGroup(verticalGroup);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(horizontalNameGroup).addGroup(horizontalValueGroup)).addGroup(horizontalCombinedGroup));
                tabContent.add(subgroupPanel);
                if (subgroup != null) {
                    subgroupPanel.setBorder(new TitledBorder(subgroup));
                }
            }
            JLabel label = new JLabel(config.getDescription());
            label.setToolTipText(config.getHint());
            String configKey = config.getConfigKey();
            JComponent valueComponent = config.getType().getComponent(configKey, configKey == null ? null : properties.getProperty(configKey), openingFrame);
            valueComponent.setToolTipText(config.getHint());
            if (config.getType().isPreferedAsMultiline()) {
                verticalGroup.addGap(2, 2, 2).addComponent(label).addComponent(valueComponent);
                horizontalCombinedGroup.addComponent(label, GroupLayout.Alignment.LEADING, -2, -2, Short.MAX_VALUE).addComponent(valueComponent, GroupLayout.Alignment.CENTER);
                continue;
            }
            verticalGroup.addGroup(layout.createBaselineGroup(false, true).addComponent(label).addComponent(valueComponent, 24, 24, 24)).addGap(2, 2, 2);
            horizontalNameGroup.addComponent(label, GroupLayout.Alignment.LEADING, -2, -2, Short.MAX_VALUE);
            horizontalValueGroup.addComponent(valueComponent, GroupLayout.Alignment.TRAILING, -2, -2, -2);
        }
        openingFrame.pack();
        return openingFrame;
    }

    private ConfigFrame(ClientConfiguration configuration) {
        super("\u8a2d\u5b9a");
        this.properties = configuration.getConfigProperties();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new FrameWindowListener());
    }

    public Object setValue(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    static {
        staticHolder = new Object();
    }

    private class FrameWindowListener
    extends WindowAdapter {
        private FrameWindowListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosing(WindowEvent e) {
            Object object = staticHolder;
            synchronized (object) {
                openingFrame = null;
                ConfigFrame.this.properties.store("Auto generated by jp.syuriken.snsw.twclient.config.ConfigFrame");
            }
        }
    }
}

