/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TreeSet;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.filter.FilterCompiler;
import jp.syuriken.snsw.twclient.filter.FilterDispatcherBase;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.MessageFilterAdapter;
import jp.syuriken.snsw.twclient.filter.NullFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserMentionEntity;

public class UserFilter
extends MessageFilterAdapter
implements PropertyChangeListener {
    private static final String PROPERTY_KEY_FILTER_GLOBAL_QUERY = "core.filter._global";
    private static final String PROPERTY_KEY_FILTER_IDS = "core.filter.user.ids";
    private TreeSet<Long> filterIds;
    private final ClientConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(UserFilter.class);
    private FilterDispatcherBase query;

    public UserFilter(ClientConfiguration configuration) {
        this.configuration = configuration;
        configuration.getConfigProperties().addPropertyChangedListener(this);
        this.filterIds = new TreeSet();
        this.initFilterIds();
        this.initFilterQueries();
    }

    private boolean filterUser(long userId) {
        return this.filterIds.contains(userId);
    }

    private boolean filterUser(Status status) {
        return this.filterUser(status.getUser());
    }

    private boolean filterUser(User user) {
        return this.filterUser(user.getId());
    }

    private void initFilterIds() {
        String idsString = this.configuration.getConfigProperties().getProperty(PROPERTY_KEY_FILTER_IDS);
        if (idsString == null) {
            return;
        }
        int offset = 0;
        while (offset < idsString.length()) {
            int end = idsString.indexOf(32, offset);
            if (end < 0) {
                end = idsString.length();
            }
            String idString = idsString.substring(offset, end);
            try {
                this.filterIds.add(Long.parseLong(idString));
            }
            catch (NumberFormatException e) {
                this.logger.warn("filterIds\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc: {} \u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093", (Object)idString);
            }
            offset = end + 1;
        }
    }

    private void initFilterQueries() {
        String query = this.configuration.getConfigProperties().getProperty(PROPERTY_KEY_FILTER_GLOBAL_QUERY);
        if (query == null || query.trim().isEmpty()) {
            this.query = NullFilter.getInstance();
        } else {
            try {
                this.query = FilterCompiler.getCompiledObject(this.configuration, query);
            }
            catch (IllegalSyntaxException e) {
                this.logger.warn("#initFilterQueries()", (Throwable)e);
            }
        }
    }

    @Override
    public boolean onDeletionNotice(long directMessageId, long userId) {
        return this.filterUser(userId);
    }

    @Override
    public StatusDeletionNotice onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        return this.filterUser(statusDeletionNotice.getUserId()) ? null : statusDeletionNotice;
    }

    @Override
    public DirectMessage onDirectMessage(DirectMessage message) {
        boolean filtered = this.filterUser(message.getSenderId());
        if (!filtered) {
            filtered = this.filterUser(message.getRecipientId());
        }
        if (!filtered) {
            filtered = this.query.filter(message);
        }
        return filtered ? null : message;
    }

    @Override
    public boolean onFavorite(User source, User target, Status favoritedStatus) {
        boolean filtered = this.filterUser(source);
        if (!filtered) {
            filtered = this.filterUser(target);
        }
        if (!filtered) {
            filtered = this.onStatus(favoritedStatus) == null;
        }
        return filtered;
    }

    @Override
    public boolean onFollow(User source, User followedUser) {
        boolean filtered = this.filterUser(source);
        if (!filtered) {
            filtered = this.filterUser(followedUser);
        }
        return filtered;
    }

    @Override
    public boolean onRetweet(User source, User target, Status retweetedStatus) {
        boolean filtered = this.filterUser(source);
        if (!filtered) {
            filtered = this.filterUser(target);
        }
        if (!filtered) {
            boolean bl = filtered = this.onStatus(retweetedStatus) == null;
        }
        if (!filtered) {
            filtered = this.query.filter(retweetedStatus);
        }
        return filtered;
    }

    @Override
    public boolean onScrubGeo(long userId, long upToStatusId) {
        return this.filterUser(userId);
    }

    @Override
    public Status onStatus(Status status) {
        boolean filtered = this.filterUser(status);
        if (!filtered && status.isRetweet()) {
            boolean bl = filtered = this.onStatus(status.getRetweetedStatus()) == null;
        }
        if (!filtered && status.getInReplyToUserId() != -1L) {
            filtered = this.filterUser(status.getInReplyToUserId());
        }
        UserMentionEntity[] userMentionEntities = status.getUserMentionEntities();
        if (!filtered && userMentionEntities != null) {
            int length = userMentionEntities.length;
            for (int i = 0; !filtered && i < length; ++i) {
                filtered = this.filterUser(userMentionEntities[i].getId());
            }
        }
        if (!filtered) {
            filtered = this.query.filter(status);
        }
        return filtered ? null : status;
    }

    @Override
    public boolean onUnblock(User source, User unblockedUser) {
        boolean filtered = this.filterUser(source);
        if (!filtered) {
            filtered = this.filterUser(unblockedUser);
        }
        return filtered;
    }

    @Override
    public boolean onUnfavorite(User source, User target, Status unfavoritedStatus) {
        boolean filtered = this.filterUser(source);
        if (!filtered) {
            filtered = this.filterUser(target);
        }
        if (!filtered) {
            filtered = this.onStatus(unfavoritedStatus) == null;
        }
        return filtered;
    }

    @Override
    public boolean onUserListCreation(User listOwner, UserList list) {
        return this.filterUser(listOwner);
    }

    @Override
    public boolean onUserListDeletion(User listOwner, UserList list) {
        return this.filterUser(listOwner);
    }

    @Override
    public boolean onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        boolean filtered = this.filterUser(addedMember);
        if (!filtered) {
            filtered = this.filterUser(listOwner);
        }
        return filtered;
    }

    @Override
    public boolean onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        boolean filtered = this.filterUser(deletedMember);
        if (!filtered) {
            filtered = this.filterUser(listOwner);
        }
        return filtered;
    }

    @Override
    public boolean onUserListSubscription(User subscriber, User listOwner, UserList list) {
        boolean filtered = this.filterUser(subscriber);
        if (!filtered) {
            filtered = this.filterUser(listOwner);
        }
        return filtered;
    }

    @Override
    public boolean onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        boolean filtered = this.filterUser(subscriber);
        if (!filtered) {
            filtered = this.filterUser(listOwner);
        }
        return filtered;
    }

    @Override
    public boolean onUserListUpdate(User listOwner, UserList list) {
        return this.filterUser(listOwner);
    }

    @Override
    public boolean onUserProfileUpdate(User updatedUser) {
        return this.filterUser(updatedUser);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PROPERTY_KEY_FILTER_IDS)) {
            this.initFilterIds();
        } else if (evt.getPropertyName().equals(PROPERTY_KEY_FILTER_GLOBAL_QUERY)) {
            this.initFilterQueries();
        }
    }
}

