/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter.prop;

import java.lang.reflect.Constructor;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.filter.FilterOperator;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import twitter4j.DirectMessage;
import twitter4j.Status;

public class StandardBooleanProperties
implements FilterProperty {
    private static final byte PROPERTY_ID_RETWEETED = 1;
    private static final byte PROPERTY_ID_MINE = 2;
    private static final byte PROPERTY_ID_PROTECTED = 3;
    private static final byte PROPERTY_ID_VERIFIED = 4;
    private static final byte PROPERTY_ID_DM = 5;
    private static final byte PROPERTY_ID_STATUS = 6;
    private static Constructor<? extends FilterProperty> factory;
    private final FilterOperator operatorType;
    private final boolean value;
    private final byte propertyId;
    private final ClientConfiguration configuration;

    public static Constructor<? extends FilterProperty> getFactory() {
        return factory;
    }

    public StandardBooleanProperties(ClientConfiguration configuration, String name, String operator, Object value) throws IllegalSyntaxException {
        this.configuration = configuration;
        switch (name) {
            case "retweeted": {
                this.propertyId = 1;
                break;
            }
            case "mine": {
                this.propertyId = (byte)2;
                break;
            }
            case "protected": {
                this.propertyId = (byte)3;
                break;
            }
            case "verified": {
                this.propertyId = (byte)4;
                break;
            }
            case "dm": {
                this.propertyId = (byte)5;
                break;
            }
            case "status": {
                this.propertyId = (byte)6;
                break;
            }
            default: {
                throw new IllegalSyntaxException("[StandardBooleanProperties] \u5bfe\u5fdc\u3057\u3066\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3067\u3059\u3002\u30d0\u30b0\u5831\u544a\u3092\u304a\u9858\u3044\u3057\u307e\u3059: " + name);
            }
        }
        this.operatorType = operator == null ? FilterOperator.IS : FilterOperator.compileOperatorBool(operator);
        if (this.operatorType == null) {
            throw new IllegalSyntaxException("[" + name + "] \u6b63\u3057\u304f\u306a\u3044bool\u6f14\u7b97\u5b50\u3067\u3059: " + operator);
        }
        if (value == null || value instanceof Boolean) {
            if (!(this.operatorType == FilterOperator.IS || this.operatorType == FilterOperator.IS_NOT)) {
                if (value == null) {
                    throw new IllegalSyntaxException("[" + name + "] \u6bd4\u8f03\u5024\u304c\u5fc5\u8981\u3067\u3059");
                }
                this.value = (Boolean)value;
            } else {
                this.value = false;
            }
        } else {
            throw new IllegalSyntaxException("[" + name + "] \u5024\u304cbool\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
    }

    @Override
    public boolean filter(DirectMessage directMessage) {
        boolean target;
        switch (this.propertyId) {
            case 5: {
                return true;
            }
            case 1: 
            case 6: {
                return false;
            }
            case 2: {
                target = this.configuration.isMyAccount(directMessage.getSenderId());
                break;
            }
            case 4: {
                target = directMessage.getSender().isVerified();
                break;
            }
            case 3: {
                target = directMessage.getSender().isProtected();
                break;
            }
            default: {
                throw new AssertionError((Object)"StandardBooleanProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    @Override
    public boolean filter(Status status) {
        boolean target;
        switch (this.propertyId) {
            case 5: {
                return false;
            }
            case 6: {
                return true;
            }
            case 1: {
                target = status.isRetweet();
                break;
            }
            case 2: {
                target = this.configuration.isMyAccount(status.getUser().getId());
                break;
            }
            case 3: {
                target = status.getUser().isProtected();
                break;
            }
            case 4: {
                target = status.getUser().isVerified();
                break;
            }
            default: {
                throw new AssertionError((Object)"StandardBooleanProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    static {
        try {
            factory = StandardBooleanProperties.class.getConstructor(ClientConfiguration.class, String.class, String.class, Object.class);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

