/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter.prop;

import java.lang.reflect.Constructor;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.filter.FilterOperator;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import twitter4j.DirectMessage;
import twitter4j.Status;

public class StandardIntProperties
implements FilterProperty {
    private static final byte PROPERTY_ID_USERID = 1;
    private static final byte PROPERTY_ID_IN_REPLY_TO_USERID = 2;
    private static final byte PROPERTY_ID_RT_COUNT = 3;
    private static final byte PROPERTY_ID_TIMEDIFF = 4;
    private static Constructor<? extends FilterProperty> factory;
    private FilterOperator operatorType;
    private long value;
    private byte propertyId;

    public static Constructor<? extends FilterProperty> getFactory() {
        return factory;
    }

    public StandardIntProperties(ClientConfiguration configuration, String name, String operator, Object value) throws IllegalSyntaxException {
        switch (name) {
            case "userid": {
                this.propertyId = 1;
                break;
            }
            case "in_reply_to_userid": {
                this.propertyId = (byte)2;
                break;
            }
            case "rtcount": {
                this.propertyId = (byte)3;
                break;
            }
            case "timediff": {
                this.propertyId = (byte)4;
                break;
            }
            default: {
                throw new IllegalSyntaxException("[StandardIntProperties] \u5bfe\u5fdc\u3057\u3066\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3067\u3059\u3002\u30d0\u30b0\u5831\u544a\u3092\u304a\u9858\u3044\u3057\u307e\u3059: " + name);
            }
        }
        if (operator == null) {
            throw new IllegalSyntaxException("[" + name + "] \u6b63\u3057\u3044int\u6f14\u7b97\u5b50\u304c\u5fc5\u8981\u3067\u3059");
        }
        this.operatorType = FilterOperator.compileOperatorInt(operator);
        if (this.operatorType == null) {
            throw new IllegalSyntaxException("[" + name + "] \u6b63\u3057\u304f\u306a\u3044int\u6f14\u7b97\u5b50\u3067\u3059: " + operator);
        }
        if (!(value instanceof Long)) {
            if (value == null) {
                throw new IllegalSyntaxException("[" + name + "] \u6bd4\u8f03\u5024\u304c\u5fc5\u8981\u3067\u3059");
            }
            throw new IllegalSyntaxException("[" + name + "] \u5024\u304c\u6574\u6570\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        this.value = (Long)value;
    }

    @Override
    public boolean filter(DirectMessage directMessage) {
        long target;
        switch (this.propertyId) {
            case 1: {
                target = directMessage.getSenderId();
                break;
            }
            case 2: {
                target = directMessage.getRecipientId();
                break;
            }
            case 3: {
                return false;
            }
            case 4: {
                target = (System.currentTimeMillis() - directMessage.getCreatedAt().getTime()) / 1000L;
                break;
            }
            default: {
                throw new AssertionError((Object)"StandardIntProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    @Override
    public boolean filter(Status status) {
        long target;
        switch (this.propertyId) {
            case 1: {
                target = status.getUser().getId();
                break;
            }
            case 2: {
                target = status.getInReplyToUserId();
                if (target != -1L) break;
                return false;
            }
            case 3: {
                target = status.getRetweetCount();
                break;
            }
            case 4: {
                target = (System.currentTimeMillis() - status.getCreatedAt().getTime()) / 1000L;
                break;
            }
            default: {
                throw new AssertionError((Object)"StandardIntProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    static {
        try {
            factory = StandardIntProperties.class.getConstructor(ClientConfiguration.class, String.class, String.class, Object.class);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

