/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.jni;

import java.lang.reflect.InvocationTargetException;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGnome {
    private static final Logger logger = LoggerFactory.getLogger(JavaGnome.class);
    private final ClassLoader extraClassLoader;
    private final Class<?> versionClass;

    public static JavaGnome getInstance(ClientConfiguration configuration) {
        return new JavaGnome(configuration);
    }

    public JavaGnome(ClientConfiguration configuration) {
        Class<?> versionClass1;
        this.extraClassLoader = configuration.getExtraClassLoader();
        try {
            versionClass1 = Class.forName("org.freedesktop.bindings.Version", true, this.extraClassLoader);
        }
        catch (ClassNotFoundException e) {
            versionClass1 = null;
        }
        this.versionClass = versionClass1;
    }

    public String getApiVersion() {
        if (this.versionClass == null) {
            return null;
        }
        try {
            return (String)this.versionClass.getMethod("getAPI", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.warn("#getApiVersion", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warn("#getApiVersion", e.getCause());
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public String getVersion() {
        if (this.versionClass == null) {
            return null;
        }
        try {
            return (String)this.versionClass.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.warn("#getVersion", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warn("#getVersion", e.getCause());
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean isFound() {
        return this.versionClass != null;
    }
}

