/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WayBackDate {
    private static final SimpleDateFormat DateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final SimpleDateFormat DateFmt2 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private String wayBackTime = "0";
    private Date date = null;
    private String time = "";
    public static final String STR_FMT = "yyyy\uff0fMM\uff0fdd_HH\uff1amm\uff1ass";
    public static final String STR_FMT_REGEX = "[0-9]{4}(\uff0f[0-3][0-9]){2}_[0-2][0-9](\uff1a[0-5][0-9]){2}";
    private static final SimpleDateFormat MyDateFmt = new SimpleDateFormat("yyyy\uff0fMM\uff0fdd_HH\uff1amm\uff1ass");

    public WayBackDate(String time) {
        this.parse(time);
    }

    public synchronized boolean parse(String time) {
        Date tmpdate = null;
        if (time == null || time.isEmpty() || time.equals("0")) {
            return false;
        }
        try {
            tmpdate = DateFmt.parse(time);
        }
        catch (ParseException ex) {
            tmpdate = null;
        }
        if (tmpdate == null) {
            try {
                tmpdate = DateFmt2.parse(time);
            }
            catch (ParseException ex2) {
                tmpdate = null;
            }
            if (tmpdate == null) {
                try {
                    tmpdate = DateFmt2.parse(String.valueOf(time) + " 0:0");
                    time = String.valueOf(time) + " 0:0";
                }
                catch (ParseException ex3) {
                    tmpdate = null;
                }
            }
        }
        if (tmpdate != null) {
            this.wayBackTime = Long.toString(tmpdate.getTime() / 1000L);
        } else {
            try {
                long tmp_time = Long.parseLong(time);
                this.wayBackTime = Long.toString(tmp_time);
                tmpdate = new Date(tmp_time * 1000L);
            }
            catch (NumberFormatException ex4) {
                return false;
            }
        }
        this.time = time;
        this.date = tmpdate;
        return true;
    }

    public boolean isValid() {
        return this.date != null;
    }

    public String getWayBackTime() {
        return this.wayBackTime;
    }

    public String getTime() {
        return this.time;
    }

    public long getSecond() {
        return this.date.getTime() / 1000L;
    }

    public static String format(String time) {
        return new WayBackDate(time).format();
    }

    public synchronized String format() {
        if (this.date != null) {
            return MyDateFmt.format(this.date);
        }
        return "";
    }

    public static synchronized String formatNow() {
        return MyDateFmt.format(new Date());
    }

    public static Date unFormat(String time) {
        try {
            return MyDateFmt.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

