/*
First author tiritomato 2013.

mqsdx is distributed under the GNU Lesser General Public License(LGPL).

support blog (Japanese only)
http://d.hatena.ne.jp/tiri_tomato/
*/

#include "../MQ0x.hpp"

namespace MQ0x {
	
	SettingProxy::SettingProxy( Handle handle ) : m_plugin( handle.plugin ), m_setting(NULL) {
		if ( m_plugin != NULL ) m_setting = m_plugin->OpenSetting();
	}
	void SettingProxy::Close() {
		if ( m_plugin != NULL && m_setting != NULL ) m_plugin->CloseSetting(m_setting);
		m_plugin = NULL;
		m_setting = NULL;
	}

	template <typename T> inline bool MQSettingLoad( MQSetting* setting, const char* name, T& value, T default_value ) {
		if ( setting == NULL ) return false;
		setting->Load( name, value, default_value );
		return true;
	}
	bool SettingProxy::Load( const char *name, bool& value, bool default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, int& value, int default_value) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, unsigned int& value, unsigned int default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, float& value, float default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, std::string& value, std::string default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}

	template <typename T> inline bool MQSettingSave( MQSetting* setting, const char* name, const T& value ) {
		if ( setting == NULL ) return false;
		setting->Save( name, value );
		return true;
	}
	bool SettingProxy::Save(const char *name, const bool& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const int& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const unsigned int& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const float& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const char* value) { return MQSettingSave( m_setting, name, std::string(value) ); }
	bool SettingProxy::Save(const char *name, const std::string& value) { return MQSettingSave( m_setting, name, value ); }

}