/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;
import org.omegat.core.Core;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class Submenu {
    private static final FileSystemView fs = FileSystemView.getFileSystemView();
    private static final FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && !file.isHidden();
        }
    };
    private static final ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Submenu.open(e.getActionCommand());
        }
    };
    private static final MouseListener mol = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JMenu m = (JMenu)e.getSource();
            if (m.isEnabled()) {
                Submenu.open(m.getActionCommand());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    private static final MenuListener mel = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isEnabled()) {
                File folder = new File(menu.getActionCommand());
                File[] filteredListFiles = Submenu.getFilteredListFiles(folder);
                try {
                    Submenu.prepare(folder, menu, filteredListFiles);
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            ((JMenu)e.getSource()).removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private static final Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            if (f1.isFile() == f2.isFile()) {
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
            return f1.isFile() ? 1 : -1;
        }
    };

    private Submenu() {
    }

    public static void create(File file, JMenu parent) throws IOException {
        File[] filteredListFiles;
        if (file.isDirectory() && (filteredListFiles = Submenu.getFilteredListFiles(file)).length > 0) {
            parent.add(Submenu.createMenu(file));
            return;
        }
        parent.add(Submenu.createMenuItem(file));
    }

    public static JMenu create(File folder, String label, JMenu parent) throws IOException {
        if (folder.isDirectory()) {
            JMenu m = Submenu.createMenu(folder, label);
            parent.add(m);
            return m;
        }
        return Submenu.create(label, parent);
    }

    public static JMenu create(String label, JMenu parent) throws IOException {
        JMenu m = Submenu.createMenu(label);
        m.setEnabled(false);
        parent.add(m);
        return m;
    }

    public static Icon getIcon(File file) {
        return fs.getSystemIcon(file);
    }

    public static File[] getFilteredListFiles(File folder) {
        return folder.listFiles(ff);
    }

    public static ActionListener getActionListener() {
        return al;
    }

    public static MouseListener getMouseListener() {
        return mol;
    }

    public static MenuListener getMenuListener() {
        return mel;
    }

    public static Comparator getComparator() {
        return comp;
    }

    public static void open(String path) {
        try {
            switch (Platform.getOsType()) {
                case WIN64: 
                case WIN32: {
                    Desktop.getDesktop().open(new File(path));
                    break;
                }
                case MAC64: 
                case MAC32: {
                    Runtime.getRuntime().exec(new String[]{ResourceBundle.getBundle("org/omegat/plugin/foldermenu/Bundle").getString("OPEN"), path});
                    break;
                }
                default: {
                    Runtime.getRuntime().exec(new String[]{ResourceBundle.getBundle("org/omegat/plugin/foldermenu/Bundle").getString("XDG-OPEN"), path});
                    break;
                }
            }
        }
        catch (IOException ex) {
            Core.getMainWindow().showMessageDialog(StaticUtils.format(L10n.getErrMsgFileHasNoAssoc(), path));
        }
    }

    public static void associate(JMenu menu, File folder) throws IOException {
        menu.setActionCommand(folder.getCanonicalPath());
        menu.setIcon(Submenu.getIcon(folder));
        menu.setEnabled(true);
    }

    public static void removeChildren(JMenu menu) {
        menu.setEnabled(false);
        menu.removeAll();
        menu.setActionCommand("");
        menu.setIcon(null);
    }

    private static JMenuItem createMenuItem(File file) throws IOException {
        JMenuItem m = new JMenuItem(file.getName(), Submenu.getIcon(file));
        m.setActionCommand(file.getCanonicalPath());
        m.addActionListener(Submenu.getActionListener());
        return m;
    }

    private static JMenuItem createMenuItem(File folder, String label) throws IOException {
        JMenuItem m = new JMenuItem(Submenu.getIcon(folder));
        Mnemonics.setLocalizedText((AbstractButton)m, (String)label);
        m.setActionCommand(folder.getCanonicalPath());
        m.addActionListener(Submenu.getActionListener());
        return m;
    }

    private static JMenu createMenu(File folder) throws IOException {
        JMenu m = new JMenu(folder.getName());
        m.setIcon(Submenu.getIcon(folder));
        m.setActionCommand(folder.getCanonicalPath());
        m.addMenuListener(Submenu.getMenuListener());
        m.addMouseListener(Submenu.getMouseListener());
        m.setEnabled(true);
        return m;
    }

    private static JMenu createMenu(String label) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)m, (String)label);
        m.addMenuListener(Submenu.getMenuListener());
        m.addMouseListener(Submenu.getMouseListener());
        return m;
    }

    private static JMenu createMenu(File folder, String label) throws IOException {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)m, (String)label);
        m.setIcon(Submenu.getIcon(folder));
        m.setActionCommand(folder.getCanonicalPath());
        m.addMenuListener(Submenu.getMenuListener());
        m.addMouseListener(Submenu.getMouseListener());
        m.setEnabled(true);
        return m;
    }

    private static void prepare(File folder, JMenu menu, File[] filteredListFiles) throws IOException {
        if (menu.getItemCount() > 0) {
            return;
        }
        menu.setIcon(Submenu.getIcon(folder));
        menu.setActionCommand(folder.getCanonicalPath());
        Arrays.sort(filteredListFiles, Submenu.getComparator());
        Submenu.createSubmenus(filteredListFiles, menu);
    }

    private static void createSubmenus(File[] files, JMenu parent) {
        for (File file : files) {
            try {
                Submenu.create(file, parent);
            }
            catch (IOException ex) {
                Log.log(ex);
            }
        }
    }
}

