/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.moenizer;

import com.sun.java.swing.plaf.windows.WindowsMenuBarUI;
import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.SplitContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.PanelUI;
import org.omegat.core.Core;
import org.omegat.plugin.moenizer.MoeDockViewTitleBarUI;
import org.omegat.plugin.moenizer.MoeLayeredPane;
import org.omegat.util.gui.UIThreadsUtil;

public class MoeUI {
    private static MoeUI moeUI = null;
    private JFrame frame;
    private MoeLayeredPane layeredPane;
    private Container contentPane;
    private JMenuBar menuBar;
    private DockingDesktop desktop;

    private MoeUI(BufferedImage image) {
        UIThreadsUtil.mustBeSwingThread();
        this.initUI(image);
    }

    private MoeUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.initUI(null);
    }

    public static MoeUI getMoeUI(BufferedImage image) {
        if (moeUI == null) {
            moeUI = new MoeUI(image);
        }
        return moeUI;
    }

    public static MoeUI getMoeUI() {
        if (moeUI == null) {
            moeUI = new MoeUI();
        }
        return moeUI;
    }

    public void transparent() {
        UIThreadsUtil.mustBeSwingThread();
        this.transparent(this.menuBar);
        this.transparentRecursive(this.contentPane);
        this.transparentInstantStart(this.desktop);
        this.frame.repaint();
    }

    public void transparentEditor() {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane editor = this.getJEditorPaneFromEditor(this.desktop);
        if (editor == null) {
            return;
        }
        editor.setOpaque(false);
        this.frame.repaint();
    }

    public void setBackground(final BufferedImage image) {
        UIThreadsUtil.executeInSwingThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MoeUI.this.layeredPane.setBackground(image);
            }
        });
    }

    private void initUI(BufferedImage image) {
        this.frame = Core.getMainWindow().getApplicationFrame();
        this.layeredPane = image == null ? new MoeLayeredPane() : new MoeLayeredPane(image);
        this.contentPane = this.frame.getContentPane();
        this.menuBar = this.frame.getJMenuBar();
        this.desktop = this.getDockingDesktop(this.contentPane);
        this.frame.setLayeredPane(this.layeredPane);
        this.frame.setContentPane(this.contentPane);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.validate();
    }

    private void transparent(JMenuBar menuBar) {
        menuBar.setUI((MenuBarUI)new WindowsMenuBarUI(){

            public void paint(Graphics g, JComponent c) {
                int alpha = 100;
                Color oldColor = g.getColor();
                SystemColor color = SystemColor.menu;
                g.setColor(new Color(color.getRGB() & 0xFFFFFF | alpha << 24, true));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                g.setColor(oldColor);
            }
        });
        menuBar.setOpaque(false);
    }

    private void transparentRecursive(Component component) {
        JComponent c;
        if (component instanceof JComponent && (c = (JComponent)component).isOpaque()) {
            c.setOpaque(false);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c2 : container.getComponents()) {
                this.transparentRecursive(c2);
            }
        }
        if (component instanceof DockingDesktop) {
            this.transparentRecursive((DockingDesktop)component);
        }
    }

    private void transparentRecursive(DockingDesktop desktop) {
        for (DockableState d : desktop.getDockables()) {
            double width = d.getPosition().getWidth();
            if (width != 0.0) continue;
            this.transparentRecursive(d);
        }
    }

    private void transparentRecursive(DockableState dockableState) {
        DockViewTitleBar titleBar;
        Dockable dockable = dockableState.getDockable();
        Container container = dockable.getComponent().getParent();
        DockView view = (DockView)container;
        if (view.isOpaque()) {
            view.setOpaque(false);
        }
        if ((titleBar = view.getTitleBar()).isOpaque()) {
            titleBar.setOpaque(false);
        }
        titleBar.setUI((PanelUI)((Object)new MoeDockViewTitleBarUI(titleBar)));
        container = container.getParent();
        if (container == null) {
            return;
        }
        if (container.isOpaque()) {
            ((SplitContainer)container).setOpaque(false);
        }
        if ((container = container.getParent()) == null) {
            return;
        }
        if (container.isOpaque()) {
            ((SplitContainer)container).setOpaque(false);
        }
    }

    private void transparentInstantStart(DockingDesktop desktop) {
        for (DockableState d : desktop.getDockables()) {
            Dockable dockable = d.getDockable();
            String key = dockable.getDockKey().getKey();
            if (!key.equalsIgnoreCase("EDITOR")) continue;
            JScrollPane sp = (JScrollPane)dockable.getComponent();
            JTextPane tp = (JTextPane)sp.getViewport().getView();
            tp.setText(tp.getText().replace(" bgcolor=\"white\"", ""));
            tp.setCaretPosition(0);
            return;
        }
    }

    private DockingDesktop getDockingDesktop(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof DockingDesktop)) continue;
            return (DockingDesktop)c;
        }
        return null;
    }

    private JEditorPane getJEditorPaneFromEditor(DockingDesktop desktop) {
        for (DockableState d : desktop.getDockables()) {
            Dockable dockable = d.getDockable();
            if (!dockable.getDockKey().getKey().equalsIgnoreCase("EDITOR")) continue;
            JScrollPane sp = (JScrollPane)dockable.getComponent();
            return (JEditorPane)sp.getViewport().getView();
        }
        return null;
    }
}

