# encoding: utf-8
#-----------------------------------------------------------
# Rumix Rakefile
#
# Requirement:
#   Ruby (1.8.0 later)
#   Rake - <http://rake.rubyforge.org/> or `gem install rake` with RubyGems
#   Exerb - <http://exerb.sourceforge.jp/>
#   Info-Zip - If you use Windows, you can get it from GnuWin32 <http://gnuwin32.sourceforge.net/>
#   msvcr71.dll, msvcp71.dll
#
# Author:   Dice <tetradice@gmail.com>
# License:  NYSL 0.9982 <http://www.kmonos.net/nysl/>
# URL:      http://ruby.morphball.net/rumix/
#-----------------------------------------------------------


require 'rake/clean'
require 'yaml'

# Adaptable to both RSpec 1 and 2
rspec_version = nil
begin
	# for RSpec 2
	require 'rspec/core/rake_task'
	rspec_version = 2
rescue LoadError
	begin
		# for RSpec 1
		require 'spec/rake/spectask'
		rspec_version = 1
	rescue LoadError
		puts "RSpec is not available."
	end
end

require './lib/rumix/const'
include Rumix

RUMIX_VERSION_STR = '20130911'

RUBY_DESCRIPTIONS = {}
RUBY_DESCRIPTIONS[RubyType::RUBY_1_9] = "ruby 1.9.3p362 (2012-12-25) [i386-mingw32]"
RUBY_DESCRIPTIONS[RubyType::RUBY_1_8] = "ruby 1.8.7 (2012-10-12 patchlevel 371) [i386-mingw32]"
RUBY_DESCRIPTIONS[RubyType::RUBY_2_0_I386] = "ruby 2.0.0p0 (2013-02-24) [i386-mingw32]"

UNINSTALLER_ZIP = 'package/uninstaller.zip'
UNINSTALLER_SRCS = FileList.new
UNINSTALLER_SRCS.include('rumix_uninstall.exe')

SRCS = FileList.new
SRCS.include(UNINSTALLER_ZIP)
SRCS.include('res/**/*')
SRCS.include('license/**/*')
SRCS.include('rumix_install.exe')
SRCS.include('rumix_install_cli.exe')
SRCS.include('*_license.txt')
SRCS.include('readme.txt')
#SRCS.include('*.dll')
SRCS.include('package/archives_info.yml')
SRCS.include('package/uninstaller.zip')
SRCS.include('package/nyaos.zip')
SRCS.include('package/ckw-mod.zip')

SRCS.include('package/bitclust-core-*.gem')
SRCS.include('package/refe2-*.gem')
SRCS.include('package/rack-*.gem')
SRCS.include('package/bundler-*.gem')
SRCS.include('package/facets-*.gem')
SRCS.include('package/ocra-*.gem')


class Package
	attr_accessor :name, :package_title, :package_ruby_types, :file_list
	def initialize(name, package_title, package_ruby_types)
		self.name = name
		self.package_title = package_title
		self.package_ruby_types = package_ruby_types
		self.file_list = SRCS.dup
	end

	def zip_file_name
		"rumix2-#{RUMIX_VERSION_STR}-#{name}.zip"
	end

	def rumix_ini_content
		descriptions = package_ruby_types.map{|x| RUBY_DESCRIPTIONS[x]}.join(',')
		ini = <<TEXT
[General]
EditionName = #{package_title}
RubyVersions = #{package_ruby_types.join(',')}
RubyDescriptions = #{descriptions}
TEXT

		return ini
	end
end

PACKAGES = []

pkg_standard = Package.new('standard', 'Rumix Standard', [RubyType::RUBY_2_0_I386])
pkg_standard.file_list.include('package/ruby-2.0.0-i386.zip')
pkg_standard.file_list.include('package/rubyrefm-remix-2.0.0.zip')
pkg_standard.file_list.include('package/refmdb-2.0.0.zip')
pkg_standard.file_list.include('package/devkit-mingw64-32.zip')
PACKAGES << pkg_standard

pkg_triple = Package.new('triple', 'Rumix Triple', [RubyType::RUBY_2_0_I386, RubyType::RUBY_1_9, RubyType::RUBY_1_8])
pkg_triple.file_list.include('package/pik-*.gem')
pkg_triple.file_list.include('package/ruby-1.9.3.zip')
pkg_triple.file_list.include('package/ruby-1.8.7.zip')
pkg_triple.file_list.include('package/ruby-2.0.0-i386.zip')
pkg_triple.file_list.include('package/rubyrefm-remix-1.9.3.zip')
pkg_triple.file_list.include('package/rubyrefm-remix-1.8.7.zip')
pkg_triple.file_list.include('package/rubyrefm-remix-2.0.0.zip')
pkg_triple.file_list.include('package/refmdb-2.0.0.zip')
pkg_triple.file_list.include('package/refmdb-1.9.3.zip')
pkg_triple.file_list.include('package/refmdb-1.8.7.zip')
pkg_triple.file_list.include('package/devkit-tdm32.zip')
pkg_triple.file_list.include('package/devkit-mingw64-32.zip')
PACKAGES << pkg_triple

pkg = Package.new('ruby1.9.3', 'Rumix (Ruby 1.9.3版)', [RubyType::RUBY_1_9])
pkg.file_list.include('package/ruby-1.9.3.zip')
pkg.file_list.include('package/rubyrefm-remix-1.9.3.zip')
pkg.file_list.include('package/refmdb-1.9.3.zip')
pkg.file_list.include('package/devkit-tdm32.zip')
PACKAGES << pkg

pkg = Package.new('ruby1.8.7', 'Rumix (Ruby 1.8.7版)', [RubyType::RUBY_1_8])
pkg.file_list.include('package/ruby-1.8.7.zip')
pkg.file_list.include('package/rubyrefm-remix-1.8.7.zip')
pkg.file_list.include('package/refmdb-1.8.7.zip')
pkg.file_list.include('package/devkit-tdm32.zip')
PACKAGES << pkg



ORIGINAL_SRCS = FileList.new
ORIGINAL_SRCS.include('readme.txt')
ORIGINAL_SRCS.include('*.ini')
ORIGINAL_SRCS.include('rumix_*.rb')
ORIGINAL_SRCS.include('*.exe.manifest')
ORIGINAL_SRCS.include('Rakefile.rb')
ORIGINAL_SRCS.include('lib/**/*')
ORIGINAL_SRCS.include('res/**/*')
ORIGINAL_SRCS.include('license/**/*')

PACKAGE_ZIP = 'rumix-0.0-bundled-package.zip'
PACKAGE_SRCS = FileList['package/*.zip']
PACKAGE_SRCS.exclude('package/uninstaller.zip')

CLEAN.include('*.filelist', '*.exy')
CLEAN.include('*.log')
CLEAN.include('temp/**/*')
CLEAN.include('__wxautoload.rb')
CLOBBER.include('rumix-*.zip', 'rumix_*.exe', UNINSTALLER_ZIP)
ZIP = 'zip'


desc '-'
task :checkenv do
	require 'tempfile'

	data = [
		[ZIP, '--version'],
		['ocra', '--help']
	]
	
	results = []
	
	# Kernel#system output to STDOUT
	data.each do |name, *args|
		if sh(name, *args) then
			results << [true, name, $?]
		else
			results << [false, name, $?]
		end
	end
	
	puts
	puts '--------------------------------'
	
	results.each do |suc, name, code|
		if suc then
			puts "#{name} is OK."
		else
			puts "#{name} is NG... (#{code})"
		end
	end
	
end



task :default => [:build]

desc "Clobber and package."
task :repackage => [:clobber, :package]


PACKAGE_TASKS = []
PACKAGES_BY_INI_PATH = {}
PACKAGES.each do |pkg|
	temp_ini_path = "temp/#{pkg.name}/rumix.ini"
	PACKAGES_BY_INI_PATH[temp_ini_path] = pkg
	directory File.dirname(temp_ini_path)

	desc '-'
	file temp_ini_path => [File.dirname(temp_ini_path)] do |task|
		# ini create
		open(task.name, 'w'){|f|
			f.write PACKAGES_BY_INI_PATH[task.name].rumix_ini_content
		}
	end

	desc "make package zip - #{pkg.zip_file_name}"
	file pkg.zip_file_name => [temp_ini_path] + pkg.file_list do |task|
		if File.exist?(task.name) then
			rm task.name
		end
	
		puts "#{task.name} archiving..."
		src_list = (task.prerequisites.to_a - [temp_ini_path]).map{|x| %Q|"#{x}"|}.join(' ')
		sh "#{ZIP} #{task.name} #{src_list}" or raise "`zip` command is not installed."

		cd File.dirname(temp_ini_path) do
			sh "#{ZIP} ../../#{task.name} rumix.ini" or raise "`zip` command is not installed."
		end

		puts "#{task.name} maked."

	end

	PACKAGE_TASKS << pkg.zip_file_name
end

desc '-'
task :usbrumix => 'temp/standard/rumix.ini' do
	#rm_r 'temp/usbrumix-standard-base' if File.exist?('temp/usbrumix-standard-base')
	sh "ruby -Ku rumix_install_cli.rb -d temp/usbrumix-standard-base --usbrumix --ini temp/standard/rumix.ini --system-safe ruby devkit nyaos-ckw refm-chm ocra bundler facets"

	cd 'temp/usbrumix-standard-base' do
		rm 'rumix_uninstall.exe'
		#rm 'rumix_uninstall.exe.manifest'
	end

end




desc "make uninstaller zip"
file UNINSTALLER_ZIP => UNINSTALLER_SRCS do |task|
	if File.exist?(task.name) then
		rm task.name
	end

	puts "#{task.name} archiving..."
	src_list = task.prerequisites.to_a.map{|x| %Q|"#{x}"|}.join(' ')
	sh "#{ZIP} #{task.name} #{src_list}" or raise "`zip` command is not installed."

	puts "#{task.name} maked."

end

desc "Package all release files, with Info-zip."
task :package => PACKAGE_TASKS# + ['rumix-0.0_src.zip', PACKAGE_ZIP]

desc "compile script files to windows-exe files by exerb."
task :build => ['rumix_install.exe', 'rumix_install_cli.exe', 'rumix_uninstall.exe', UNINSTALLER_ZIP]



# rule '.exe' => '.exy' do |task|
# 	sh "exerb -v #{task.source}"
# end

# ['rumix_install', 'rumix_uninstall'].each do |name|
# 	file "#{name}.exy" => (FileList['*.rb'] + FileList['lib/**/*.rb'] + ['__wxautoload.rb']) do |task|
# 		sh "ruby -Ku -r exerb/mkexy #{name}.rb"
	
# 		data = YAML.load_file(task.name)
# 		data['general']['core'] = 'gui'
# 		data['file']['msvcr71.dll'] = {'type' => 'dynamic-library'}
# 		data['file']['msvcp71.dll'] = {'type' => 'dynamic-library'}
# 		data['file']['zlib1.dll'] = {'type' => 'dynamic-library'}
		
# 		data['resource'] ||= {}
# 		data['resource']['icon'] = []
		
# 		icon_info = []
# 		icon_info << [4, 32]
# 		icon_info << [4, 16]
# 		icon_info << [8, 32]
# 		icon_info << [8, 16]
# 		icon_info << [32, 256]
# 		icon_info << [32, 48]
# 		icon_info << [32, 32]
# 		icon_info << [32, 24]
# 		icon_info << [32, 16]
		
		
# 		icon_info.each do |color, size|
# 				data['resource']['icon'] << {'file' => 'res/image/ce_jacas/ruby_ns.ico', 'width' => size, 'height' => size, 'color' => color}
# 		end
		
# 		open(task.name, 'w'){|f| f.write(data.to_yaml)}
		
# 	end
# end

file 'rumix_install_cli.exy' => (FileList['*.rb'] + FileList['lib/**/*.rb']) do |task|
	sh 'ruby -Ku -r exerb/mkexy rumix_install_cli.rb'
end

['rumix_install', 'rumix_uninstall', 'rumix_install_cli'].each do |name|
	file "#{name}.exe" => (FileList['*.rb'] + FileList['lib/**/*.rb'] + ['__wxautoload.rb']) do |task|
		sh "ocra --windows --icon res/image/ce_jacas/ruby_ns.ico --dll rubyw.exe.manifest #{name}.rb"
	end
end


file 'rumix_install_cli.exy' => (FileList['*.rb'] + FileList['lib/**/*.rb']) do |task|
	sh 'ruby -Ku -r exerb/mkexy rumix_install_cli.rb'
end


# This file is generated because Exerb and WxRuby are not friendly.
# (refer to 'Load in all the class extension methods' in lib/wx.rb)
file '__wxautoload.rb' do |task|
	list = nil
	cd 'lib' do
		list = Dir.glob('wx/**/*.rb')
	end
		
	open(task.name, 'w'){|f|
		f.puts "# This file was generated by Rake."
		f.puts "require 'wx'"
		list.each do |name|
			f.puts "require '#{name}'"
		end
	}
	
	puts "#{task.name} maked."
end





if rspec_version then
	case rspec_version
	when 1
		task_cls = Spec::Rake::SpecTask
		rspec_opts_setting_proc = proc do |task|
			task.spec_opts << '-fs'
			task.ruby_opts = ['-Ku']
		end
	when 2
		task_cls = RSpec::Core::RakeTask
		rspec_opts_setting_proc = proc do |task|
			task.verbose = true
			task.rspec_opts = ['-fs']
			task.ruby_opts = ['-Ku']
		end
	else
		raise 'unknown rspec version.'
	end
	
	desc "Run all spec files. (alias: test)"
	task_cls.new do |st|
		rspec_opts_setting_proc.call(st)
		st.pattern = 'spec/*.rb'
	end
	
	namespace :spec do
		desc "Run spec files of Registry."
		task_cls.new(:registry) do |st|
			rspec_opts_setting_proc.call(st)
			st.pattern = 'spec/registry.rb'
		end
	end
	
	task :test => :spec
end
