# encoding: utf-8

module Rumix
	Tool = Struct.new(:id, :name)

	VERSION_NUMBER = 1.90
	VERSION = '1.90'
	TOOL_LIST_COMMON = [
		Tool.new(:devkit, 'DevKit'),
		#Tool.new(:rake, 'Rake 0.9.2.2', 25 * 2),
		#Tool.new(:rdoc_data, 'rdoc-data', 50),
		Tool.new(:refe, 'ReFe2 0.5.5'),
		Tool.new(:ocra, 'Ocra 1.3.0'),
		Tool.new(:facets, 'Facets 2.9.3'),
		Tool.new(:bundler, 'Bundler 1.3.0'),
		#Tool.new(:ansicon_win32console, 'ANSICON + Win32::Console', 40 * 2),
		#Tool.new(:sqlite, 'SQLite 3.7.13 + sqlite3-ruby 1.3.6', 40 * 2),
	]

	GEM_WEIGHTS = {}
	GEM_WEIGHTS['bitclust-core'] = 84
	GEM_WEIGHTS['bundler'] = 224 
	GEM_WEIGHTS['facets'] = 281 
	GEM_WEIGHTS['ocra'] =  101
	GEM_WEIGHTS['pik'] =  
	GEM_WEIGHTS['refe2'] =  

	module OperationLevel
		FULL = '03 (full)'
		SYSTEM_SAFE = '02 (system safe)'
		DRY_RUN = '01 (dry run)'
	end


	module RubyType
		RUBY_1_8 = 'ruby-1.8'
		RUBY_1_9 = 'ruby-1.9'
		RUBY_2_0_I386 = 'ruby-2.0-i386'
		RUBY_2_0_X64 = 'ruby-2.0-x64'
	end

	module DevkitType
		TDM32 = 'tdm32'
		MINGW64_32 = 'mingw64-32'
		MINGW64_64 = 'mingw64-64'
	end

	DEVKIT_DESCRIPTIONS = {}
	DEVKIT_DESCRIPTIONS[DevkitType::TDM32] = "Devkit"
	DEVKIT_DESCRIPTIONS[DevkitType::MINGW64_32] = "Devkit (mingw64_32版)"
	DEVKIT_DESCRIPTIONS[DevkitType::MINGW64_64] = "Devkit (mingw64_64版)"


	NYAOS_VERSION = '3.2.0_7'
	CKW_VERSION = '0.9.0-d2'
	PIK_VERSION = '0.2.8'

	COPY_OPTIONS = {:preserve => true}
	CUI_HELP_SENTENCE = "(If you want the manual of Rumix, add option '-h' or '--help')"
	
	ZIP_CHUNK_SIZE = 1024 * 4  # 4KB
	
	module ManualType
		CHM_OLD = 'chm_old'
		CHM_NEW = 'chm_new'
		CHM_NEW_REMIX = 'chm_new_remix'
		NONE = 'none'
	end
	
	module ShellType
		NYAOS_CKW = 'nyaos_ckw'
		NYAOS = 'nyaos'
		NONE = 'none'
	end

	

end
