# encoding: utf-8

require 'fileutils'
include FileUtils

require 'rumix'
include Rumix

INSTALL_PATTERNS = []
INSTALL_PATTERNS << ['ruby_only', 'ruby', {:ruby_check => true}]
INSTALL_PATTERNS << ['ruby_and_nyaos', 'ruby nyaos-ckw', {:ruby_check => true, :nyaos_check => true}]


describe Rumix::Application do
	
	INSTALL_PATTERNS.each do |id, targets, options|
		describe "Install Pattern = #{id} (targets = #{targets}, options = #{options.inspect}): " do
			before(:all) do
				@dest_dir = "./cuiexptest/#{id}"
				rm_r(@dest_dir, :verbose => true) if File.exist?(@dest_dir)
				
				cmd = %Q|ruby rumix_install_cli.rb --dest #{@dest_dir} #{targets}"|
				puts cmd
				@result = system(cmd)
			end
		
			it "is success" do
				@result.should be_true
			end
			
			it "makes dest directories" do
				Pathname.new(@dest_dir).should be_exist
			end
			
			if options[:ruby_check] then
				it "makes ruby directories" do
					(Pathname.new(@dest_dir) + 'ruby/1.8/i386-mingw/').should be_exist
					(Pathname.new(@dest_dir) + 'ruby/1.8/i386-mingw/bin/ruby.exe').should be_exist
				end
			else
				it "doesn't make ruby directories" do
					(Pathname.new(@dest_dir) + 'ruby').should_not be_exist
				end
			end
			
			if options[:nyaos_check] then
				it "makes nyaos files" do
					(Pathname.new(@dest_dir) + 'shell/nyaos/nyaos.exe').should be_exist
					(Pathname.new(@dest_dir) + 'shell/nyaos/_nya').should be_exist
					(Pathname.new(@dest_dir) + 'shell/nyaos/_nya_rumix').should be_exist
				end
			else
				it "doesn't make nyaos files" do
					(Pathname.new(@dest_dir) + 'shell/nyaos/nyaos.exe').should_not be_exist
				end
			end
		
			it "makes .rumix-inst/rumix.yml" do
				(Pathname.new(@dest_dir) + '.rumix-inst/rumix.yml').should be_exist
			end

			
		end
	end
end