#encoding: utf-8
$LOAD_PATH << './lib'
require 'wx'
require 'win32ole'
require '__wxautoload'
require 'dl/win32'


module Rumix
	module Util
		module_function
		
		def run(cmd)
			@wsh.Run(cmd)
		end
		
		def run_on_ckw(cmd)
			run(%Q|start d:\\nyaos\\ckw.exe -e d:\\nyaos\\nyaos.exe|)
		end
		
		def run_on_thread(&proc)
			stop_running_thread
		
			Thread.abort_on_exception = true
			
			thread = Thread.new{
				proc.call
			}
			timer = Wx::Timer.every(1) do
				Thread.pass
			end
			
			@running_thread = thread
			@running_timer = timer
			
			return thread
		end
		
		def stop_running_thread
			if @running_thread then
				@running_thread.kill
			end
			
			if @running_timer then
				@running_timer.stop
			end
		end
	
	end
	
	include Util

	class App < Wx::App
	  private
	
	  def on_init
			"app initialize start."
		
	    Wx::XmlResource.get.load('rumix.xrc')
		  MainFrame.new.show
				
			
			return(!ARGV.include?('--test-run'))
	  end
	end
	
	class MainFrame < Wx::Frame
		
		def initialize
			super
			
			@wsh = WIN32OLE.new("Wscript.Shell")
			#@send_message = Win32API.new("user32", "SendMessage",['L']*4,'L')
			
			Wx::XmlResource.get.load_frame_subclass(self, nil, 'FrmMain')
			
			evt_button(find_window_by_name('BtnNyaosWithCkw')) do
				run %Q|d:\\nyaos\\ckw.exe|
			end
			evt_button(find_window_by_name('BtnIrb')) do
				run %Q|d:\\nyaos\\ckw.exe -e d:\\nyaos\\nyaos.exe -v|
			end
			evt_button(find_window_by_name('BtnPry')) do
				run %Q|d:\\nyaos\\ckw.exe -e "pry.bat"|
			end
			evt_button(find_window_by_name('BtnReferenceManual')) do
				run %Q|D:\\rumix\\refm.chm|
			end
			evt_button(find_window_by_name('BtnGemManager')) do
				GemManagerDialog.new.show_modal
			end
			#@send_message.call(find_window_by_name('BtnGemManager').handle, 0x160c, 0, 1)
		end
	end
	
	class ProgressDialog < Wx::Dialog
		
		def initialize(&block)
			super()
			
			Wx::XmlResource.get.load_dialog_subclass(self, nil, 'ProgressDialog')
			
			@gauge = find_window_by_name('GauProgress')
			
			label_process = find_window_by_name('LblProcess')
			
			
			timer = Wx::Timer.every(1) do
				Thread.pass
				Wx::get_app.dispatch while Wx::get_app.pending
				@gauge.pulse
			end
			
			t = Thread.new do
				block.call(label_process, @gauge)
				timer.stop
				self.end_modal(0)
			end
			t.abort_on_exception = true
			
			evt_button(find_window_by_name('BtnCancel')) do
				t.kill
				timer.stop
				end_modal(0)
			end

		end
	end

	
	class GemManagerDialog < Wx::Dialog
		
		def initialize
			super
			
			@wsh = WIN32OLE.new("Wscript.Shell")
			Wx::XmlResource.get.load_dialog_subclass(self, nil, 'GemManagerDialog')
			
			

			
			@local_page = find_window_by_name('notebook').get_page(0)
			@remote_page = find_window_by_name('notebook').get_page(1)
			@local_list = @local_page.find_window_by_name('LstGem')
			@local_list.clear
			@remote_list = @remote_page.find_window_by_name('LstGem')
			@remote_list.clear
			
			Wx::Timer.after(50) do
				puts :timer_start
				dlg = ProgressDialog.new do |static_text, gauge|
					static_text.label = 'ローカルのgemを取得中...'
					wsh_exec = @wsh.Exec('gem.bat list -l')
					
					while wsh_exec.Status == 0 do
						sleep(0.01)
					end
					#out = wsh_exec.StdOut.ReadAll

					
					static_text.label = 'リモートのgemを取得中...'
=begin
					wsh_exec = @wsh.Exec('gem.bat list -r')
					
					while wsh_exec.Status == 0 do
						sleep(0.01)
						gauge.pulse
						#wsh_exec.StdOut.ReadAll
					end
					#out = wsh_exec.StdOut.ReadAll
=end
					IO.popen('gem.bat list -r'){|io|
						puts "something to input"
						puts io.read
					}
				end
				puts :generated
				dlg.show_modal
				puts :shown

=begin			
				run_on_thread do
					list_output = `gem list -l`
					list_output.each_line do |line|
						if line =~ /(\S+) \((.+)\)$/ then
							gem_name, gem_versions = $1, $2
							@local_list.append("#{gem_name} (#{gem_versions})")
						end
					end
					
					list_output = `gem list -r`
					list_output.each_line do |line|
						if line =~ /(\S+) \((.+)\)$/ then
							gem_name, gem_versions = $1, $2
							@remote_list.append("#{gem_name} (#{gem_versions})")
						end
					end
					
					puts :ok.
					
					dlg.hide
				end
=end				
			end
			

			evt_button(find_window_by_name('BtnClose')) do
				end_modal(0)
			end

			evt_listbox(@local_list) do |evt|
				@local_page.find_window_by_name('LblGemName').label = evt.string
			end
			
			evt_listbox(@remote_list) do |evt|
				@remote_page.find_window_by_name('LblGemName').label = evt.string
			end

		end
	end
end



Rumix::App.new.main_loop
