# encoding: utf-8

require 'facets/pathname'

require 'rumix/const'
require 'rumix/function'
require 'rumix/config'
require 'rumix/osinterface'

module Rumix
	class Application
		def self.run(config, log_io = $stderr, &block)
			self.new.run(config, log_io, &block)
		end
	
		public
		
		def initialize
			@installed_file_list_output = nil
		end
		
		def run(config, log_io = $stderr, &block)
			log_io.puts(<<ECHO)
---------------
Rumix Installer
---------------
dest : #{config.dest_dir}
ECHO

			# OSInterfaceオブジェクトを生成
			osi = OSInterface.new(config, log_io)
			
			# インストール先フォルダと、インストール情報を格納するためのサブフォルダを作成
			osi.mkpath(Pathname[config.dest_dir] / '.rumix-inst/')
			
			# インストールで選択した情報を書き込む
			if config.real_operating? then
				open(Pathname[config.dest_dir] /  '.rumix-inst/rumix-setting.yml', 'w'){|f|
					f.write config.serialize_input_state_to_yaml
				}
			end

			# インストール済みファイルを書き込むための準備
			if config.real_operating? then
				osi.installed_file_list_output = open(Pathname[config.dest_dir] /  '.rumix-inst/installed.txt', 'w')
			end
		
			# レジストリに情報を書き込む
			osi.write_install_path_to_registry

			# アンインストーラのインストール
			block.call(:on_uninstaller_install_start) if block
			osi.install_from_zip('uninstaller.zip', config.dest_dir, &block)
			block.call(:on_uninstaller_install_complete) if block

			# rubyのインストール
			config.ruby_configs.each do |ruby_conf|
				block.call(:on_ruby_install_start, [ruby_conf]) if block
				osi.install_from_zip(ruby_conf.ruby_zip_file_name, ruby_conf.ruby_dir, &block)
				block.call(:on_ruby_install_complete, [ruby_conf]) if block
			end
			
			# リファレンスのインストール
			config.ruby_manual_zip_file_names.each do |zip_name|
				block.call(:on_man_install_start) if block
				osi.install_from_zip(zip_name, Pathname[config.dest_dir] / 'reference', &block)
				block.call(:on_man_install_complete) if block
			end
			
			# シェルのインストール
			block.call(:on_shell_install_start) if block
			case config.shell_type
			when ShellType::NYAOS_CKW
				osi.install_from_zip('nyaos.zip', Pathname[config.dest_dir] / 'shell/nyaos', &block)
				osi.install_from_zip('ckw-mod.zip', Pathname[config.dest_dir], &block)
				osi.install_from_zip('ckw-mod-document.zip', Pathname[config.dest_dir] / 'shell/ckw-mod', &block)

				# ckw.cfg の設定を書き換え（書き換え前にバックアップを取っておく）
				osi.backup_file('ckw.cfg')
				cfg_path = Pathname[config.dest_dir] / 'ckw.cfg'
				cfg_body = File.read(cfg_path)
				cfg_body.gsub!(/^Ckw\*title:.+$/, "Ckw*title: NYAOS with ckw")
				cfg_body.gsub!(/^Ckw\*exec:.+$/, "Ckw*exec: shell/nyaos/nyaos.exe")

				if config.real_operating? then
					open(cfg_path, 'w'){|f|
						f.write cfg_body
					}
				end
				log_io.puts "rewrite #{cfg_path}"
				
				# _nyaの設定内に、Rumix用のshellを呼び出すための設定を追加
				nya_config_path = Pathname[config.dest_dir] / 'shell/nyaos/_nya'
				nya_rumix_config_path = Pathname[config.dest_dir] / 'shell/nyaos/_nya_rumix'
				osi.backup_file('shell/nyaos/_nya')
				
				nya_config_body = File.read(nya_config_path)
				nya_config_body.gsub!(/^#=BEGIN RUMIX(.+?)#=END RUMIX$/m, '')
				nya_config_body += <<ECHO

#=BEGIN RUMIX
# set NYAOSDIR environment (nyaos.exe directory path)
lua_e "
    function get_nyaos_dir()
        dir_path, match_count = string.gsub(nyaos.argv[0], '\\\\nyaos.exe$', '')
        return dir_path
    end
"
set NYAOSDIR=`lua_e "print(get_nyaos_dir())"`

# Read custom script of Rumix
source %NYAOSDIR%\\_nya_rumix
#=END RUMIX

ECHO

				# _nya_rumixの設定内に、rubyのパスを設定
				if config.default_ruby_config then
					osi.rewrite_nya_rumix('RUBY_BINDIR', config.default_ruby_config.ruby_bin_dir_for_nyaos)
				end
	
				if config.real_operating? then
					open(nya_config_path, 'w'){|f|
						f.write(nya_config_body)
					}
				end
				log_io.puts "rewrite #{nya_config_path}"


			when ShellType::NYAOS
				osi.install_from_zip('nyaos.zip', Pathname[config.dest_dir] / 'shell/nyaos', &block)
			end
			#osi.create_shortcut(config.dest_dir, 'nyaos.exe', 'shell/nyaos.exe')
			block.call(:on_shell_install_complete) if block
			
			# devkitのインストール
			if config.installing_tool_ids.include?(:devkit) then
				# すべてのdevkitごとに処理を実行
				config.devkit_types.each do |devkit_type|
					zip_name = "devkit-#{devkit_type}.zip"
					block.call(:on_devkit_install_start, [devkit_type, zip_name]) if block
					devkit_dest_dir_pathname = Pathname[config.dest_dir] / 'ruby' / File.basename(zip_name, '.zip')

					# インストール実行
					osi.install_from_zip(zip_name, devkit_dest_dir_pathname, &block)

					block.call(:on_devkit_setup_start) if block

					# 対象とするrubyの種別をチェック
					target_ruby_configs = config.ruby_configs.find_all{|x| x.devkit_type == devkit_type}
					target_ruby_descs = target_ruby_configs.map{|x| x.ruby_short_description }.join(', ')
					log_io.puts "Setup devkit #{devkit_type} (targets = #{target_ruby_descs})"

					if config.real_operating? then
						osi.cd(devkit_dest_dir_pathname) do
							osi.sh("#{config.default_ruby_config.ruby_command} dk.rb init")
							open('config.yml', 'a'){|f|
								target_ruby_configs.each do |ruby_conf|
									path = ruby_conf.ruby_dir_pathname.cleanpath.to_s
									f.puts "- #{path}"
								end
							}
							osi.sh("#{config.default_ruby_config.ruby_command} dk.rb install")
						end
					end
					block.call(:on_devkit_install_complete) if block
				end
			end
			
			
			# pikのインストール
			if config.pik_should_be_installed? then
				block.call(:on_pik_install_start) if block

				# pik gemをインストール
				osi.install_gems(['pik'], :no_document => true, :no_event => true, &block)

				# ここからはシステム全体に影響する処理
				if config.system_changable? then

					# pik_installを実行
					osi.mkpath(config.pik_dir_pathname)
					osi.sh("#{config.default_ruby_config.ruby_command} #{config.default_ruby_config.ruby_bin_dir}\\pik_install #{config.pik_dir_pathname.cleanpath.to_s}")

					# すべてのrubyをpikに登録
					config.ruby_configs.each do |ruby_conf|
						osi.sh("#{config.pik_command} add #{ruby_conf.ruby_bin_dir}")
					end
				end

				block.call(:on_pik_install_complete) if block
			end

			if config.installing_tool_ids.include?(:exerb) then
				block.call(:on_tool_install_start, [:exerb]) if block
				osi.install_tool('exerb', 'setup.rb')
				block.call(:on_tool_install_complete, [:exerb]) if block
			end
			
			if config.installing_tool_ids.include?(:visualuruby) then
				block.call(:on_tool_install_start, [:visualuruby]) if block
				osi.install_tool('visualuruby', 'setup.rb')
				
				# swin.so を手動でコピー（setup.rb はこの作業をやってくれない）
				osi.install_from_zip("swin.zip", File.join(main_ruby_dir, 'lib/ruby/site_ruby/1.8/i386-msvcrt'))
				
				# FormDesigner.bat を作成
				cmd_dest = File.join(main_ruby_dir, 'bin/FormDesigner.bat')
				original_cmd = File.join(main_ruby_dir, 'bin/FormDesigner.rb')

				if config.real_operating? then
					open(cmd_dest, 'w'){|f|
						bat = <<CMD
@ECHO OFF
IF NOT "%~f0" == "~f0" GOTO :WinNT
@"ruby.exe" "#{original_cmd}" %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO :EOF
:WinNT
@"ruby.exe" "%~dpn0.rb" %*
CMD
						f.puts(bat)
						log_io.puts "#{cmd_dest} maked."
					}
				end

				block.call(:on_tool_install_complete, [:visualuruby]) if block
			end
			
			# ReFe2インストール
			if config.installing_tool_ids.include?(:refe) then
				block.call(:on_gem_install_start, ['ReFe2']) if block
				# 必要なgemをインストール
				osi.install_gems(%w(rack bitclust-core refe2), :pik_enabled => true, &block)
				block.call(:on_gem_install_complete, %w(rack bitclust-core refe2)) if block

				# ドキュメントデータのインストール
				block.call(:on_refe_document_install_start) if block
				
				# 標準rubyのバージョンに合致するリファレンスデータを展開
				default_ruby_conf = config.default_ruby_config
				osi.install_from_zip("refmdb-#{default_ruby_conf.ruby_version}.zip", default_ruby_conf.bitclust_database_dir, &block)
				
					
				# 環境変数REFE2_DATADIRを設定
				osi.set_env('REFE2_DATADIR', default_ruby_conf.bitclust_database_dir_pathname.cleanpath.to_s)

				block.call(:on_refe_document_install_complete) if block
			end

			# gemのインストール
			if config.installing_tool_ids.include?(:facets) then
				block.call(:on_gem_install_start, ['Ruby Facets']) if block
				osi.install_gems(%w(facets), &block)
				block.call(:on_gem_install_complete, %w(facets)) if block
				#reserved_gem_names << 'facets'
			end
			if config.installing_tool_ids.include?(:bundler) then
				block.call(:on_gem_install_start, ['Bundler']) if block
				osi.install_gems(%w(bundler), &block)
				block.call(:on_gem_install_complete, %w(bundler)) if block
				#reserved_gem_names << 'facets'
			end
			if config.installing_tool_ids.include?(:ocra) then
				block.call(:on_gem_install_start, ['Ocra']) if block
				osi.install_gems(['ocra'], &block)
				block.call(:on_gem_install_complete, %w(ocra)) if block
				#reserved_gem_names << 'ocra'
			end
			if config.installing_tool_ids.include?(:yard) then
				block.call(:on_gem_install_start, ['YARD']) if block
				osi.install_gems(['yard'], &block)
				block.call(:on_gem_install_complete, %w(yard)) if block
				#reserved_gem_names << 'ocra'
			end
			if config.installing_tool_ids.include?(:rake) then
				block.call(:on_gem_install_start, ['Rake']) if block
				osi.install_gems(['rake'], &block)
				block.call(:on_gem_install_complete, %w(rake)) if block
				#reserved_gem_names << 'rake'
			end
			if config.installing_tool_ids.include?(:rdoc_data) then
				block.call(:on_gem_install_start, ['rdoc-data']) if block
				osi.install_gems(%w(json rdoc rdoc-data), &block)
				block.call(:on_gem_install_complete, %w(json rdoc rdoc-data)) if block
				#reserved_gem_names << 'json' << 'rdoc' << 'rdoc-data'
			end
			
			# SQLite3 + sqlite3-rubyのインストール
			if config.installing_tool_ids.include?(:sqlite3) then
				reserved_gem_names << 'sqlite3'
				osi.install_from_zip('sqlite3.zip', config.main_ruby_bin_dir_pathname, &block)
			end


			# 環境変数PATHの追加
			if config.add_path_env? then
				block.call(:on_path_env_add_start) if block
				ruby_bin_dir = Rumix.winpath(config.default_ruby_config.ruby_bin_dir)
				
				paths = osi.get_env('PATH').split(';')
				unless paths.include?(ruby_bin_dir) then
					paths.unshift ruby_bin_dir
				end

				pik_dir = Rumix.winpath(Pathname[config.dest_dir] / 'ruby/pik')
				if config.pik_should_be_installed? and not paths.include?(pik_dir) then
					paths.unshift pik_dir
				end

				new_path = paths.join(';')
				old_path = osi.get_env('PATH')
				log_io.puts "old PATH = #{old_path}"
				log_io.puts "new PATH = #{new_path}"
				if old_path != new_path then
					osi.set_env('PATH', new_path)
				end
				block.call(:on_path_env_add_complete) if block
			end
			
			# スタートメニューにRumix追加
			if config.add_start_menu? then
				block.call(:on_start_menu_add_start) if block
				#osi.cd(dir_path) do
				#	Dir.glob('**/*.lnk') do |path|
				#		remove_file(config, log_io, path)
				#	end
				#end

				osi.create_start_menu_shortcut('irb - Interactive Ruby Console', Pathname[config.default_ruby_config.ruby_bin_dir] / 'irb.bat')
				case config.shell_type
				when ShellType::NYAOS_CKW
					osi.create_start_menu_shortcut('NYAOS + ckw（コマンドライン端末）', Pathname[config.dest_dir] / 'ckw.exe')
					#osi.create_start_menu_shortcut('NYAOS（コマンドライン端末）', Pathname[config.dest_dir] / 'shell/nyaos/NYAOS.exe')
				when ShellType::NYAOS
					osi.create_start_menu_shortcut('NYAOS（コマンドライン端末）', Pathname[config.dest_dir] / 'shell/nyaos/NYAOS.exe')
				end

				case config.man_type
				when ManualType::CHM_NEW_REMIX
					osi.create_start_menu_shortcut('Ruby リファレンスマニュアル（Ruby 1.8.7）', Pathname[config.dest_dir] / 'rubyrefm-remix-1.8.7.chm')
				when ManualType::CHM_NEW
					osi.create_start_menu_shortcut('Ruby リファレンスマニュアル（Ruby 1.8.7）', Pathname[config.dest_dir] / 'rubyrefm-1.8.7.chm')
				when ManualType::CHM_OLD
					#osi.create_start_menu_shortcut('Ruby リファレンスマニュアル（Ruby 1.8.7）', Pathname[config.dest_dir] / 'rubyman.chm')
				end
				
				osi.create_start_menu_shortcut('Rumixのアンインストール', Pathname[config.dest_dir] / 'rumix_uninstall.exe')
				
				if config.installing_tool_ids.include?(:visualuruby) then
					osi.create_start_menu_shortcut('VisualuRuby/FormDesigner', Pathname[config.dest_dir] / 'ruby/bin/FormDesigner.bat')
					osi.create_start_menu_shortcut('VisualuRuby/VisualuRuby計画（仮称）リファレンス', Pathname[config.dest_dir] / 'ruby/share/visualuruby/vrswin-ja.chm')
				end
				
				block.call(:on_start_menu_add_complete) if block
			end
			
			
			
			block.call(:on_complete) if block

			# インストール済みファイルのリストをクローズ
			if config.real_operating? then
				osi.installed_file_list_output.close
			end

		end
	end

end
