#pragma once

#include "ofMain.h"
#include "ofxStk.h"
#include "ofxSimpleButton.h"

class testApp : public ofBaseApp, ofxSimpleButtonListener {

public:
	void setup();
	void update();
	void draw();

	void keyPressed(int key);
	void keyReleased(int key);
	void mouseMoved(int x, int y );
	void mouseDragged(int x, int y, int button);
	void mousePressed(int x, int y, int button);
	void mouseReleased(int x, int y, int button);
	void windowResized(int w, int h);
	void dragEvent(ofDragInfo dragInfo);
	void gotMessage(ofMessage msg);

	void audioOut(float * output, int size, int channels);

	void buttonNotify(ofxSimpleButtonEvent event);

private:
	int sigAreaX, sigAreaY, sigAreaW, sigAreaH;
	int buttonX, buttonY, buttonSize;
	
    vector<float> lrAudio;
	vector<ofxSimpleButton> buttons;
	vector<stk::Instrmnt*> insts;
	
	stk::BandedWG mBandedWG;
	stk::BeeThree mBeeThree;
	stk::BlowBotl mBlowBotl;
	stk::BlowHole mBlowHole;
	stk::Bowed mBowed;
	stk::Brass mBrass; // small sound?
	stk::Clarinet mClarinet;
	stk::Drummer mDrummer;
    stk::Flute mFlute;
	stk::FMVoices mFMVoices;
	
	stk::HevyMetl mHevyMetl;
	stk::Mandolin mMandolin;
	stk::Mesh2D mMesh2D;
	stk::ModalBar mModalBar;
    stk::Moog mMoog;
	stk::PercFlut mPercFlut;
	stk::Plucked mPlucked;
	stk::Resonate mResonate;
    stk::Rhodey mRhodey;
	stk::Saxofony mSaxofony;
	
	stk::Shakers mShakers;
	stk::Simple mSimple;
	stk::Sitar mSitar;
	stk::StifKarp mStifKarp;
	stk::TubeBell mTubeBell;
	stk::Wurley mWurley;
	stk::VoicForm mVoicForm; // noteOn ? from starting
	stk::Whistle mWhistle; // noteOn ? from starting
};



