/*
 *  The MIT License
 *
 *  Copyright 2011-2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.app.ListActivity;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.SparseBooleanArray;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;
import org.routine_work.simple_battery_logger.dropbox_uploader.db.CsvUploadStatusDBHelper;
import org.routine_work.util.Log;

public class UploadCsvFilesListActivity extends ListActivity
	implements View.OnClickListener, CheckBox.OnCheckedChangeListener
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";
	private List<CsvUploadStatus> csvUploadStatusList = new ArrayList<CsvUploadStatus>();
	CsvUploadStatusListAdapter listAdapter;
	private CsvUploadStatusDBHelper dbHelper;
	private SQLiteDatabase db;

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.ok_button:
				Log.d(LOG_TAG, "ok_button is clicked.");
				uploadCheckedCsvFiles();
				setResult(RESULT_OK);
				finish();
				break;
			case R.id.cancel_button:
				Log.d(LOG_TAG, "cancel_button is clicked.");
				setResult(RESULT_CANCELED);
				finish();
				break;
		}
	}

	public void onCheckedChanged(CompoundButton cb, boolean checked)
	{
		switch (cb.getId())
		{
			case R.id.check_all_checkbox:
				setCheckedAll(checked);
				break;
		}
	}

	/**
	 *
	 * @param savedInstanceState
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.csv_upload_status_list_activity);

		dbHelper = new CsvUploadStatusDBHelper(this);
		db = dbHelper.getWritableDatabase();

		CheckBox checkAllCheckBox = (CheckBox) findViewById(R.id.check_all_checkbox);
		checkAllCheckBox.setOnCheckedChangeListener(this);

		Button okButton = (Button) findViewById(R.id.ok_button);
		okButton.setOnClickListener(this);

		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);

		ListView listView = (ListView) findViewById(android.R.id.list);
		listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);

		initializeListData();
	}

	@Override
	protected void onDestroy()
	{
		if (db != null)
		{
			db.close();
			db = null;
		}
		super.onDestroy();
	}

	private void initializeListData()
	{
		Log.v(LOG_TAG, "Hello");

		listAdapter = new CsvUploadStatusListAdapter(this, csvUploadStatusList);
		setListAdapter(listAdapter);
		updateListData();

		Log.v(LOG_TAG, "Bye");
	}

	private void updateListData()
	{
		Log.v(LOG_TAG, "Hello");

		List<CsvUploadStatus> statusList = UploadServiceUtils.getCsvUploadStatusList(this);

		csvUploadStatusList.clear();
		csvUploadStatusList.addAll(statusList);
		listAdapter.notifyDataSetChanged();

		// setup default item checked 
		ListView listView = getListView();
		for (int i = csvUploadStatusList.size() - 1; i >= 0; i--)
		{
			CsvUploadStatus csvUploadStatus = csvUploadStatusList.get(i);
			boolean checked = csvUploadStatus.checkNecessaryToUpload();
//			Log.v(LOG_TAG, "i => " + i + ", checked => " + checked);
			listView.setItemChecked(i, checked);
		}

		Log.v(LOG_TAG, " Bye");
	}

	private void uploadCheckedCsvFiles()
	{
		List<String> csvFilePathList = new ArrayList<String>();
		ListView listView = getListView();
		SparseBooleanArray checkedItemPositions = listView.getCheckedItemPositions();
		for (int i = checkedItemPositions.size() - 1; i >= 0; i--)
		{
			if (checkedItemPositions.valueAt(i))
			{
				int checkedPosition = checkedItemPositions.keyAt(i);
				Object item = listView.getItemAtPosition(checkedPosition);
				if (item instanceof CsvUploadStatus)
				{
					CsvUploadStatus csvUploadStatus = (CsvUploadStatus) item;
					String csvFilePath = csvUploadStatus.getFile().getAbsolutePath();
					csvFilePathList.add(csvFilePath);
				}
			}
		}

		if (csvFilePathList.size() > 0)
		{
			Log.d(LOG_TAG, "csvFilePathList.size() => " + csvFilePathList.size());
			Toast.makeText(this, R.string.upload_csv_file_started_message, Toast.LENGTH_SHORT).show();

			// start uploading service
			Intent uploadCsvFilesServiceIntent = new Intent(this, UploadCsvFilesService.class);
			String[] csvFilePaths = csvFilePathList.toArray(new String[0]);
			uploadCsvFilesServiceIntent.putExtra(BatteryConstants.EXTRA_CSV_FILE_PATHS, csvFilePaths);
			startService(uploadCsvFilesServiceIntent);
		}

	}

	private void setCheckedAll(boolean checked)
	{
		ListView listView = getListView();
		for (int i = listView.getCount() - 1; i >= 0; i--)
		{
			listView.setItemChecked(i, checked);
		}
	}
}
