#include "ofxStk.h"

using namespace std;
using namespace stk;

typedef struct InstrmntTable {
	string name;
	ControlChangeInfo cc[16];
} InstrmntTable;

static const InstrmntTable kInstrmntTable[] = {
	{"BandedWG",
	 {
		 {"BowPressure", 2}, {"BowPosition", 4}, {"StrikePosition", 8},
		 {"AfterTouch", 128}, {"ModWheel", 1}, {"ModFrequency", 11},
		 {"Portamento", 65}, {"ProphesyRibbon", 16}
	 }
	},

	{"BeeThree", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},
	
	{"BlowBotl",
	 {
		 {"NoiseLevel", 4}, {"ModWheel", 1}, {"ModFrequency", 11},
		 {"ProphesyRibbon", 16}, {"AfterTouch", 128}
	 }
	},
	
	{"BlowHole",
	 {
		 {"ReedStiffness", 2}, {"NoiseLevel", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},
	
	{"Bowed",
	 {
		 {"BowPressure", 2}, {"BowPosition", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"BowVelocity", 100}, {"Frequency", 101},
		 {"AfterTouch", 128}
	 }
	},
	
	{"Brass",
	 {
		 {"LipTension", 2}, {"SlideLength", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"Clarinet",
	 {
		 {"ReedStiffness", 2}, {"NoiseLevel", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},
	
	{"Drummer",
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},
	
	{"Flute",
	 {
		 {"JetDelay", 2}, {"NoiseLevel", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"FMVoice",
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"HevyMetl", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"Mandolin",
	 {
		 {"BodySize", 2}, {"PickPosition", 4}, {"StringDamping", 11},
		 {"StringDetune", 1}, {"AfterTouch", 128}
	 }
	},

	{"Mesh2D",
	 {
		 {"NX", 2}, {"NY", 4}, {"Decay", 11},
		 {"ModWheel", 1},
	 }
	},

	{"ModalBar",
	 {
		 {"StickHardness", 2}, {"StrikePosition", 4}, {"ProphesyRibbon", 11},
		 {"Balance", 1}, {"ModFrequency", 11}, {"ModWheel", 1},
		 {"AfterTouch", 128}
	 }
	},

	{"Moog",
	 {
		 {"FilterQ", 2}, {"FilterSweepRate", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"PercFlut", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"Plucked", // No Parameter
	 {
		 {"", 0}
	 }
	},

	{"Resonate",
	 {
		 {"resonance", 2}, {"resonance2", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"Rhodey", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"Saxofony",
	 {
		 {"ReedStiffness", 2}, {"NoiseLevel", 4}, {"Vibrato", 29},
		 {"BowPosition", 11}, {"ModWheel", 1}, {"AfterTouch", 128},
		 {"readTableOffset", 26}
	 }
	},

	{"Shakers",
	 {
		 {"type", 1071}, {"decay", 4},
		 {"numobj", 11}, {"resonance", 1}, {"energy", 128},
	 }
	},

	{"Simple",
	 {
		 {"Breath", 2}, {"NoiseLevel", 4},
		 {"ModFrequency", 11}, {"AfterTouch", 128},
	 }
	},

	{"Sitar",
	 {
		 {"", 0}
	 }
	},

	{"StifKarp",
	 {
		 {"StringDetune", 2}, {"PickPosition", 4}, {"StringDamping", 11},
	 }
	},

	{"TubeBell", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},
	
	{"Wurley", // FM Parameter
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}
	 }
	},

	{"VoicForm",
	 {
		 {"Breath", 2}, {"FootControl", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128},
	 }
	},

	{"Whistle",
	 {
		 {"Breath", 2}, {"NoiseLevel", 4}, {"ModFrequency", 11},
		 {"ModWheel", 1}, {"AfterTouch", 128}, {"Sustain", 64},
	 }
	},
};

static bool initialized = false;
static vector<string> ofx_stk_instrmnt_names;
static vector<InstrmntInfo> ofx_stk_instrmnt_infos;

void ofxStkInit()
{
	// clear vector
	ofx_stk_instrmnt_names.clear();
	ofx_stk_instrmnt_infos.clear();

	// setup vector
	int num_instrmnt = sizeof(kInstrmntTable) / sizeof(InstrmntTable);
	
	for(int i = 0; i < num_instrmnt; i++) {
		int cc_index = 0;
		InstrmntInfo instrmnt_info;
		instrmnt_info.name = kInstrmntTable[i].name;
		while(!kInstrmntTable[i].cc[cc_index].name.empty()) {
			instrmnt_info.cc.push_back(kInstrmntTable[i].cc[cc_index++]);
		}
		ofx_stk_instrmnt_names.push_back(kInstrmntTable[i].name);
		ofx_stk_instrmnt_infos.push_back(instrmnt_info);
	}

	initialized = true;
}

const vector<string>& ofxStkGetInstrmntNames()
{
	if(!initialized) {
		ofxStkInit();
	}
	
	return ofx_stk_instrmnt_names;
}

int ofxStkGetNumControlChange(string instrmnt_name)
{
	if(!initialized) {
		ofxStkInit();
	}
	
	for(vector<InstrmntInfo>::iterator itr = ofx_stk_instrmnt_infos.begin();
		itr != ofx_stk_instrmnt_infos.end(); itr++) {
		if(((InstrmntInfo)(*itr)).name == instrmnt_name) {
			// return ((InstrmntInfo)(*itr)).cc.size();
			return itr->cc.size();
		}
	}
	
	return -1;
}

const vector<ControlChangeInfo> &ofxStkControlChangeInfos(string instrmnt_name)
{
	if(!initialized) {
		ofxStkInit();
	}
	
	for(vector<InstrmntInfo>::iterator itr = ofx_stk_instrmnt_infos.begin();
		itr != ofx_stk_instrmnt_infos.end(); itr++) {
		if(((InstrmntInfo)(*itr)).name == instrmnt_name) {
			//return ((InstrmntInfo)(*itr)).cc;
			return itr->cc;
		}
	}
	
	return ofx_stk_instrmnt_infos[0].cc;
}

Instrmnt *ofxStkNewInstrmnt(string instrmntName)
{
	int number = -1;
	for(int i = 0; i < ofx_stk_instrmnt_infos.size(); i++) {
		if(ofx_stk_instrmnt_infos[i].name == instrmntName) {
			number = i;
			break;
		}
	}

	// return Instrmnt Instance
	if      (number==0)  return new BandedWG;
	else if (number==1)  return new BeeThree;
	else if (number==2)  return new BlowBotl;
	else if (number==3)  return new BlowHole(10.0);
	else if (number==4)  return new Bowed(10.0);
	else if (number==5)  return new Brass(10.0);
	else if (number==6)  return new Clarinet(10.0);
	else if (number==7)  return new Drummer;
	else if (number==8)  return new Flute(10.0);
	else if (number==9)  return new FMVoices;
	else if (number==10) return new HevyMetl;

	else if (number==11) return new Mandolin(5.0);
	else if (number==12) return new Mesh2D(10, 10);
	else if (number==13) return new ModalBar;
	else if (number==14) return new Moog;
	else if (number==15) return new PercFlut;
	else if (number==16) return new Plucked(5.0);
	else if (number==17) return new Resonate;

	else if (number==18) return new Rhodey;
	else if (number==19) return new Saxofony(10.0);
	else if (number==20) return new Shakers;
	else if (number==21) return new Simple;
	else if (number==22) return new Sitar(5.0);
	else if (number==23) return new StifKarp(5.0);
	else if (number==24) return new TubeBell;
	else if (number==25) return new Wurley;
	else if (number==26) return new VoicForm;
	else if (number==27) return new Whistle;

	else {
		printf("\nUnknown instrument or program change requested!\n");
	}

	return NULL;
}
