#ifndef __OFX_STK__
#define __OFX_STK__

#include <string>
#include <vector>

#include "Stk.h"

// Stk Osc 
#include "BlitSaw.h"
#include "BlitSquare.h"

// Stk Instruments
#include "Moog.h"
#include "TubeBell.h"
#include "Saxofony.h"
#include "Rhodey.h"
#include "Flute.h"

#include "BandedWG.h"
#include "BeeThree.h"
#include "BlowBotl.h"
#include "BlowHole.h"
#include "Bowed.h"
#include "Brass.h"
#include "Clarinet.h"
#include "Drummer.h"
#include "FMVoices.h"

#include "HevyMetl.h"
#include "Mandolin.h"
#include "Mesh2D.h"
#include "ModalBar.h"
#include "PercFlut.h"
#include "Plucked.h"
#include "Resonate.h"
#include "Shakers.h"
#include "Simple.h"
#include "Sitar.h"
#include "StifKarp.h"
#include "VoicForm.h"
#include "Whistle.h"
#include "Wurley.h"

// Stk Utils
#include "ADSR.h"

typedef struct ControlChangeInfo {
	std::string name;
	int number;
} ControlChange;

typedef struct InstrmntInfo {
	std::string name;
	std::vector<ControlChangeInfo> cc;
} InstrmntVector;

int ofxStkGetNumControlChange(std::string instrmnt_name);
const std::vector<std::string>& ofxStkGetInstrmntNames();
const std::vector<ControlChangeInfo> &ofxStkControlChangeInfos(std::string instrmnt_name);
stk::Instrmnt *ofxStkNewInstrmnt(std::string instrmntName);

#endif // __OFX_STK__
