//
//  GrMain.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/19.
//
//

#include <vector>
#include <stdio.h>
#include "GrMain.h"

int GrBase::idCounter = 0;

GrMain::GrMain()
{
    ofLogToConsole();
}

GrMain::~GrMain()
{

}

#pragma mark -- Loop Proc --
void GrMain::update()
{
	// __update();
	
    // add preAdd Member
    mPreAddLock.lock();
    for(std::vector<GrBase*>::iterator itr = mPreAddMember.begin(); itr != mPreAddMember.end(); itr++)
    {
        addMemberImpl((GrBase*)*itr);
    }
    mPreAddMember.clear();

	// remove preRemove Member
    for(std::vector<GrBase*>::iterator itr = mPreRemoveMember.begin(); itr != mPreRemoveMember.end(); itr++)
    {
        removeMemberImpl((GrBase*)*itr);
    }
	mPreRemoveMember.clear();
    mPreAddLock.unlock();

    // update GrUpdater
    for(std::vector<GrUpdater*>::iterator itr = mGrUpdates.begin(); itr != mGrUpdates.end(); )
    {
		GrUpdater *updater = ((GrUpdater*)*itr);
        updater->update();
		if(updater->getAliveCnt()) { // alive
			itr++;
		} else { // aliveCnt == 0 -> remove
			mGrUpdates.erase(itr);
		}
    }
}

/* -- Draw -- */
void GrMain::draw()
{
    // draw GrDrawer
    for(std::vector<GrDrawer*>::iterator itr = mGrDraws.begin(); itr != mGrDraws.end(); itr++)
    {
        ((GrDrawer*)*itr)->draw();
    }
}

/* -- Mouse -- */
void GrMain::mouseMoved(int x, int y)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseMoved(x, y);
	}
}

void GrMain::mouseDragged(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseDragged(x, y, button);
	}
}

void GrMain::mousePressed(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mousePressed(x, y, button);
	}
}

void GrMain::mouseReleased(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseReleased(x, y, button);
	}
}

// add member routine
void GrMain::add(GrBase *grBase)
{
    mPreAddLock.lock();
    mPreAddMember.push_back(grBase);
    mPreAddLock.unlock();
}

// remove member routine
void GrMain::remove(GrBase *grBase)
{
	if(grBase != NULL) {
		mPreAddLock.lock();
		mPreRemoveMember.push_back(grBase);
		mPreAddLock.unlock();
	} else {
		printf("%s, remove null pointer\n", __FUNCTION__);
	}
}

// --- local class GrRemover
class GrRemover : public GrUpdater
{
public:
	GrRemover(GrMain *destination, GrBase *remove, int delay) :
		destination(destination),
		remove(remove),
		delay(delay) {};
	
	void update();
	
private:
	GrMain *destination;
	GrBase *remove;
	int delay;
};

// remove member with delay 
void GrMain::remove(GrBase *grBase, int delay)
{
	add(new GrRemover(this, grBase, delay));
}

void GrRemover::update()
{
	if(--delay == 0) {
		destination->remove(remove);
		aliveCnt = 0; // delete from GrMain
	}
}

# pragma mark --- private method ---
void GrMain::removeMemberImpl(GrBase *grBase)
{
    // Add Member Drawer ( GrDraw )
    GrDrawer *drawer = dynamic_cast<GrDrawer*>(grBase);
    if(NULL != drawer) {
		std::vector<GrDrawer*>::iterator itd = std::remove(mGrDraws.begin(), mGrDraws.end(), drawer);
		mGrDraws.erase(itd, mGrDraws.end());
	}
	
    // Add Member Updater ( GrUpdater )
    GrUpdater *updater = dynamic_cast<GrUpdater*>(grBase);
    if(NULL != updater)
    {
		std::vector<GrUpdater*>::iterator itu = std::remove(mGrUpdates.begin(), mGrUpdates.end(), updater);
		mGrUpdates.erase(itu, mGrUpdates.end());
    }

    // Add Member Mouse ( GrMouse )
    GrMouse *mouse = dynamic_cast<GrMouse*>(grBase);
    if(NULL != mouse)
    {
		std::vector<GrMouse*>::iterator itm = std::remove(mGrMouses.begin(), mGrMouses.end(), mouse);
		mGrMouses.erase(itm, mGrMouses.end());
    }

	// remove and delete
	// std::vector<ofPtr<GrBase> >::iterator it = std::remove(mGrBase.begin(), mGrBase.end(), grBase);
	// mGrBase.erase(it, mGrBase.end());
	for(std::vector<ofPtr<GrBase> >::iterator itr = mGrBase.begin(); itr != mGrBase.end();) {
		ofPtr<GrBase> ptr = *itr;
		if(ptr->id == grBase->id) {
			mGrBase.erase(itr);
		} else {
			itr++;
		}
	}
}

void GrMain::addMemberImpl(GrBase *grBase)
{
	// Add Member All
	mGrBase.push_back(ofPtr<GrBase>(grBase));
	
    // Add Member Drawer ( GrDraw )
    GrDrawer *drawer = dynamic_cast<GrDrawer*>(grBase);
    if(NULL != drawer)
    {
        mGrDraws.push_back((GrDrawer*)drawer);
    }
    
    // Add Member Updater ( GrUpdater )
    GrUpdater *updater = dynamic_cast<GrUpdater*>(grBase);
    if(NULL != updater)
    {
        mGrUpdates.push_back((GrUpdater*)updater);
    }

    // Add Member Mouse ( GrMouse )
    GrMouse *mouse = dynamic_cast<GrMouse*>(grBase);
    if(NULL != mouse)
    {
        mGrMouses.push_back((GrMouse*)mouse);
    }
}

inline void ofLoggingTouchEvent(char *name, ofTouchEventArgs &touch)
{
    ofLog(OF_LOG_ERROR, "%s,%d,%d,%f,%f,%d", name, touch.id, touch.time, touch.x, touch.y, touch.numTouches);
}


void GrMouse::mouseMoved(int x, int y )
{
	// dummy for virtual method
}

void GrMouse::mouseDragged(int x, int y, int button)
{
	// dummy for virtual method
}

void GrMouse::mousePressed(int x, int y, int button)
{
	// dummy for virtual method
}

void GrMouse::mouseReleased(int x, int y, int button)
{
	// dummy for virtual method
}
