#include "GrTextArea.h"

TextArea::TextArea(const int x, const int y, const int lineFeedWidth,
				   const ofColor &color, unsigned int numTextLine) :
	_x(x),
	_y(y),
	_linefeedWidth(lineFeedWidth),
	textColor(color),
	numTextLine(numTextLine)
{
	
}

void TextArea::addTextLine(string str) {
	mutex.lock();
	textLines.push_back(str);
	while(textLines.size() >= numTextLine) {
		textLines.erase(textLines.begin());
	}
	mutex.unlock();
}

void TextArea::draw() {
	int i = 0;
	
	mutex.lock();
	ofPushStyle();
	ofSetColor(textColor);
	for(vector<string>::iterator itr = textLines.begin(); itr != textLines.end(); itr++) {
		ofDrawBitmapString(*itr, _x, _y+(_linefeedWidth*i++));
	}
	ofPopStyle();
	mutex.unlock();
}

