#include "testApp.h"
#include "GrColors.h"
#include "GrShapeL.h"
#include "GrShapeCurve.h"
#include "GrTextArea.h"
#include "PDrawIf.h"

static const int TextAreaX = 50;
static const int TextAreaY = 50;
static const int TextAreaLineWidth = 20;
static const unsigned int TextAreaNumLine = 6;

TextArea *textArea = NULL;

extern void test_gr_001();
extern void test_au_001();

testApp::testApp() :
    sampleRate(44100),
    am(AuMain::getInstance()),
	currentMain(NULL)
{

}

void testApp::audioOut(float *output, int size, int channels)
{
    am->audioOut(output, size, channels);
}

//--------------------------------------------------------------
void testApp::setup()
{
    // of Logging Level
    ofSetLogLevel(OF_LOG_VERBOSE);

    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, AuMain::getBufferSize(), 4);
    
	// background color
	ofBackground(255,255,255);

	ofEnableAlphaBlending();
    
	// true type font
	//myFont.loadFont("frabk.ttf", 100);
	
    ofSetFrameRate(60);

	// debug text area setup

	// gm.add(textArea = new TextArea(TextAreaX, TextAreaY, TextAreaLineWidth, colorSet[0]));

	// button setup
	for(int i = 0; i < NUM_BUTTON; i++) {
		gm.add(button[i] = new GrButton((int)((0.05 + (0.05 * i)) * ofGetWidth()),
										(int)(0.95 * ofGetHeight()),
										(int)(0.025 * ofGetWidth()),
										(int)(0.025 * ofGetHeight())));
		button[i]->setColor(colorSet[COLOR_COOL_3C_DARK_BLUE]);
		button[i]->addButtonListener(this);
	}

	// test
	// test_gr_001();
    
	// test_au_001();
	
	// first GrMain instance
	buttonNotify(GR_BUTTON_PRESSED, button[2]);	
}

//--------------------------------------------------------------
void testApp::update()
{
    gm.update();
}


//--------------------------------------------------------------
void testApp::draw()
{
	ofEnableSmoothing();
	gm.draw();
}

void testApp::exit()
{

}

//--------------------------------------------------------------
void testApp::keyPressed  (int key)
{
	debugf("key=%d\n", key);
	if('1' <= key && key <= '9') {
		int numkey = (key - '1');
		debugf("number key=%d\n", numkey);
		buttonNotify(GR_BUTTON_PRESSED, button[numkey]);
	}
}

//--------------------------------------------------------------
void testApp::keyReleased  (int key)
{

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y)
{
	gm.mouseMoved(x, y);
	psig::mouseMoveX = x;
	psig::mouseMoveY = y;
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button)
{
	gm.mouseDragged(x, y, button);
	psig::mouseDragX = x;
	psig::mouseDragY = y;
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button)
{
	gm.mousePressed(x, y, button);
	psig::mousePressX = x;
	psig::mousePressY = y;
}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button)
{
	gm.mouseReleased(x, y, button);
	psig::mouseReleaseX = x;
	psig::mouseReleaseY = y;
}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg)
{

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo)
{ 

}

void testApp::windowResized(int w, int h)
{
	
}

void testApp::buttonNotify(eGrButtonEventKind kind, GrButton *b)
{
	printf("%s, %s, %d\n", __FILE__, __FUNCTION__, __LINE__);

	if(kind == GR_BUTTON_PRESSED) {
		//b->setColor(100, 150, 200);
	}

	/**
	 * remove currentMain
	 */
	if(currentMain != NULL) {
		gm.remove(currentMain);
		currentMain = NULL;
	}
	
	if(b == button[0]) {
		GrMain *pr = createPDrawTest_001();
		gm.add(currentMain = pr);
	} else if(b == button[1]) {
		GrMain *pr = createPDrawTest_002();
		gm.add(currentMain = pr);
	} else if(b == button[2]) {
		debugl();
		GrMain *gr = new GrMain();
		gr->add(new PDrawTest003(gr));
		gm.add(currentMain = gr);
	} else if(b == button[3]) {
		/**
		 * GrDraw CurveTest
		 */
		gm.add(currentMain = new CurveTest(ofGetHeight(), ofRandom(4, 10)));
	} else if(b == button[4]) {
		/**
		 * PDraw createCircle
		 */
		GrMain *pr = createCircle(100, 100, 50, 80);
		gm.add(currentMain = pr);
	} else if(b == button[5]) {
		/**
		 * PDraw createRing
		 */
		GrMain *pr = createRing(100, 100, 50, 80, 0.1);
		gm.add(currentMain = pr);
	} else if(b == button[6]) {
		/**
		 * PDraw createRectMoveCircle
		 */
		GrMain *g = createRectMoveCircle(200, 200, 150, 150, 20);
		gm.add(currentMain = g);
	} else if(b == button[7]) {
		/**
		 * PDraw createRectMoveArray
		 */
		GrMain *g = createRectMoveArray(50, 50, 250, 250, 20);
		gm.add(currentMain = g);
	} else if(b == button[8]) {
		/**
		 * PDraw 
		 */
		GrMain *g = createRectCircleSeq001(50, 50, 250, 250);
		gm.add(currentMain = g);
	} else {

	}
}

