#-------------------------------------------------------------------------------
# of_v0.8.0_osx_release向けMakefile共通定義ファイル
# 各プロジェクトのMakefileからincludeして使用する
#
# OF_CORE_HEADERS : コンパイル時に使うincludeパス
# OF_LINK         : リンク時に使うライブラリとフレームワークの設定一式
#
# + of_v0.8.0_osx_release.zipを展開する
# + MakefileのOF_PATHをof_v0.8.0_osx_release.zip展開した場所
#-------------------------------------------------------------------------------

## Openframework展開パス
OF_PATH       = $(realpath ../../of_v0.8.0_osx_release)

## ofライブラリヘッダのincludeパス
HEADER_OF        = "$(OF_PATH)/libs/openFrameworks/"
HEADER_FREETYPE  = "$(OF_PATH)/libs/freetype/include"
HEADER_FREETYPE2 = "$(OF_PATH)/libs/freetype/include/freetype2"
HEADER_POCO      = "$(OF_PATH)/libs/poco/include"
HEADER_FMODEX    = "$(OF_PATH)/libs/fmodex/include"
HEADER_GLEW      = "$(OF_PATH)/libs/glew/include"
HEADER_FREEIMAGE = "$(OF_PATH)/libs/FreeImage/include"
HEADER_TESS2     = "$(OF_PATH)/libs/tess2/include"
HEADER_CAIRO     = "$(OF_PATH)/libs/cairo/include/cairo"
HEADER_RTAUDIO   = "$(OF_PATH)/libs/rtaudio/include"

## of静的ライブラリのパス
LIB_OF              = "$(OF_PATH)/libs/openFrameworksCompiled/lib/osx/openFrameworksDebug.a" \
                      "$(OF_PATH)/libs/FreeImage/lib/osx/freeimage.a" \
                      "$(OF_PATH)/libs/freetype/lib/osx/freetype.a" \
                      "$(OF_PATH)/libs/glut/lib/osx/GLUT.framework/Versions/A/GLUT" \
                      "$(OF_PATH)/libs/glew/lib/osx/glew.a" \
                      "$(OF_PATH)/libs/glfw/lib/osx/libglfw3.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoData.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoDataODBC.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoDataSQLite.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoFoundation.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoUtil.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoXML.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoZip.a" \
                      "$(OF_PATH)/libs/rtAudio/lib/osx/rtAudio.a" \
                      "$(OF_PATH)/libs/tess2/lib/osx/tess2.a" \
                      "$(OF_PATH)/libs/cairo/lib/osx/cairo-script-interpreter.a" \
                      "$(OF_PATH)/libs/cairo/lib/osx/cairo.a" \
                      "$(OF_PATH)/libs/cairo/lib/osx/pixman-1.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoNet.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoNetSSL.a" \
                      "$(OF_PATH)/libs/poco/lib/osx/PocoCrypto.a" \
                      "$(OF_PATH)/libs/openssl/lib/osx/crypto.a"\
                      "$(OF_PATH)/libs/openssl/lib/osx/ssl.a"\

## リンクするofライブラリ
OF_CORE_LIBS     = $(LIB_OF) $(LIB_FREEIMAGE) $(LIB_FREETYPE)

## GLUT.frameworkは標準のものを使わずにofのものを使うのでパスを指定
OF_LDFLAGS     = -F$(OF_PATH)/libs/glut/lib/osx

## リンクするFramework
FRAMEWORK     = -framework AppKit \
				-framework Cocoa \
				-framework IOKit \
				-framework AGL \
				-framework ApplicationServices \
				-framework AudioToolbox \
				-framework Carbon \
				-framework CoreAudio \
				-framework CoreFoundation \
				-framework CoreServices \
				-framework OpenGL \
				-framework QuickTime \
				-framework GLUT \
				-framework Accelerate \
				-framework QTKit

## fmodのみダイナミックリンク
OF_CORE_LIBS    += $(OF_PATH)/libs/fmodex/lib/osx/libfmodex.dylib

## コンパイル時のヘッダ参照
OF_CORE_HEADERS  = -I$(HEADER_OF) -I$(HEADER_OF)/3d -I$(HEADER_OF)/app -I$(HEADER_OF)/communication -I$(HEADER_OF)/events \
					-I$(HEADER_OF)/gl -I$(HEADER_OF)/graphics -I$(HEADER_OF)/math -I$(HEADER_OF)/sound -I$(HEADER_OF)/types -I$(HEADER_OF)/utils -I$(HEADER_OF)/video \
					-I$(HEADER_POCO) -I$(HEADER_FREETYPE) -I$(HEADER_FREETYPE2) -I$(HEADER_FMODEX) -I$(HEADER_GLEW) -I$(HEADER_FREEIMAGE) -I$(HEADER_TESS2) -I$(HEADER_CAIRO) -I$(HEADER_RTAUDIO)

## リンク時にgccに渡す設定一式
OF_LINK        = $(OF_LDFLAGS) $(OF_CORE_LIBS) $(FRAMEWORK) $(OF_DYLIB)
