/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jp.sourceforge.users.yutang.omegat.plugin.stats2excel.ExcelModel;
import jp.sourceforge.users.yutang.omegat.plugin.stats2excel.L10n;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class SplashStatisticsWindow
extends StatisticsWindow {
    private ScheduledExecutorService service = null;
    private boolean isErrorOnDisplay = false;

    public SplashStatisticsWindow(StatisticsWindow.STAT_TYPE statType) {
        super(statType);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SplashStatisticsWindow.this.service != null && !SplashStatisticsWindow.this.service.isShutdown()) {
                    SplashStatisticsWindow.this.service.shutdown();
                    SplashStatisticsWindow.this.service = null;
                }
            }
        });
        this.setSize(400, 100);
    }

    @Override
    public void displayData(String result) {
        try {
            if (result == null) {
                throw new Exception("Error: Statistcs result is empty.");
            }
            this.setText(L10n.getProgressMsgLaunchingExcel());
            String title = StaticUtils.format(L10n.getExcelWindowTitle(), this.getTitle());
            ExcelModel.setWindowTitle(title);
            ExcelModel.display(result);
        }
        catch (Exception ex) {
            this.isErrorOnDisplay = true;
            Log.log(ex);
            this.setText(ex.getMessage());
        }
    }

    @Override
    public void finishData() {
        if (this.isErrorOnDisplay) {
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ExcelModel.activate()) {
                        SplashStatisticsWindow.this.service.shutdown();
                        SplashStatisticsWindow.this.service = null;
                        SplashStatisticsWindow.this.dispose();
                    }
                }
                catch (IOException ex) {
                    Log.log(ex);
                    SplashStatisticsWindow.this.setText(ex.getLocalizedMessage());
                    SplashStatisticsWindow.this.service.shutdown();
                    SplashStatisticsWindow.this.service = null;
                }
                catch (InterruptedException ex) {
                    Log.log(ex);
                    SplashStatisticsWindow.this.setText(ex.getLocalizedMessage());
                    SplashStatisticsWindow.this.service.shutdown();
                    SplashStatisticsWindow.this.service = null;
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private void setText(String text) {
        super.displayData(text);
    }
}

