/* 
 * WHAT THIS EXAMPLE DOES
 * 
 * We create a pool of 4 threads and then add 40 tasks to the pool(20 task1 
 * functions and 20 task2 functions). task1 and task2 simply print which thread is running them.
 * 
 * As soon as we add the tasks to the pool, the threads will run them. It can happen that 
 * you see a single thread running all the tasks (highly unlikely). It is up the OS to
 * decide which thread will run what. So it is not an error of the thread pool but rather
 * a decision of the OS.
 * 
 * */

#include <stdio.h>
#include "thpool.h"

#if defined(_WIN32) || defined(_WIN64)
#include <windows.h>
DWORD pthread_self(){
	return GetCurrentThreadId();
}
#else
#include <pthread.h>
#endif

void task1(void *){
	printf("Thread #%u working on task1\n", (int)pthread_self());
	Sleep(500);
	printf("Thread #%u worked on task1\n", (int)pthread_self());
}


void task2(void *){
	printf("Thread #%u working on task2\n", (int)pthread_self());
	Sleep(500);
	printf("Thread #%u worked on task2\n", (int)pthread_self());
}


int main(){
	
	puts("Making threadpool with 4 threads");
	threadpool thpool = thpool_init(4);

	puts("Adding 40 tasks to threadpool");
	int i;
	for (i=0; i<20; i++){
		thpool_add_work(thpool, task1, NULL);
		thpool_add_work(thpool, task2, NULL);
	};

	thpool_wait(thpool);
	puts("Killing threadpool");
	thpool_destroy(thpool);
	puts("Killed threadpool");
	
	return 0;
}
