#!/bin/sh
cat << 'EEE' > /dev/null
/* getdic.sh
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

fpath=$(printf `./readlinkp "$0"`'@')
fpath=${fpath%?}
fname=`basename "$fpath"`
fdir=${fpath%/*}'/'
cd "$fdir"

wd=`printf '%s' "$1" | tr '[:upper:]' '[:lower:]'`

#mkdir
if ! [ -d "mydic" ] ; then
	mkdir mydic
fi
if ! [ -d "mydic/sound" ] ; then
	mkdir mydic/sound
fi
#echo "$1"


# @text
# test: (能力などをためす)試験,検査,(ものの)検査,実験,ためすもの,試金石,試験の手段,試験,分析,鑑識
# @sound
# https://weblio.hs.llnwd.net/e7/img/dict/kenej/audio/S-D740D62_E-D742954.mp3
# @num
# 1

#リトライ2全てのタイムアウト5秒
cmd='wget -t 2 -T 5 https://ejje.weblio.jp/content/'"$wd -O -"
if [ "$cmd" = "" ] ; then
	echo "connect err" > /dev/stderr
	exit 1
fi

# htmlから自力で必要っぽいところを直接切り出し。
#翻訳表現とmp3っぽいところを人力で適当に。
buf=`$cmd | sed -ne '
/name="twitter:description"/ b label1
D
:label1
p
:label2
/mp3/ b label3
n
b label2
:label3
p;q' | java suckhtml -c @text -p content 1 -c @sound -p src 1 -c @num -c 1`
out=`printf '%s\n%s\n%s\n' "-s-$wd" "$buf" "-e-$wd"`

#https://,.. for wget
url=`printf '%s/n' "$out" | sed -ne '
/@sound/ b label1
D
:label1
n;p;q' | grep -v '^@'`


if [ "$url" = "" ] ; then
	echo "no soundFile url" > /dev/stderr
	exit 0
fi

#get file.suffix(mp3.wave.ogg etc)
suf=${url##*.}

#http...  -> ./mydic/text.mp3 ... get line_num and change name
lnum=`printf '%s\n' "$out" | cat -n - | grep -F "$url" | awk '{print $1}'`
out=`printf '%s\n' "$out" | sed "$lnum {
a./mydic/sound/$wd.$suf
D
}"`
./adddic.sh "$out"
printf '%s\n' "$out"

#'test' + '.' + 'mp3'  >> test.mp3, test2.wave   ...etc
#printf '%s\n' "$wd.$buf"
if ! [ -f "./mydic/sound/$wd.$suf" ] ; then
	wget "$url" -O ./mydic/sound/"$wd.$suf"
else
	echo "soundFile already exist." > /dev/stderr
fi

# tsocks1 ./getdic.sh text
