#!/bin/sh
cat << 'EEE' > /dev/null
/* urdic.sh 
 * Copyright (C) 2018,2019 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

func_rlp() {
# GPL_3+ license
# '(' ... for local scope
(
rlp_input='cat -'	
if [ "$#" != '0' ] ; then
	rlp_input='for ii
do
	printf "%s\000" "$ii"
done'
fi

# ...awk for detect input err.
eval "$rlp_input" | od -An -to1 -w16 -v | awk -v bf="$0" '
BEGIN{err=1} 
$0 ~ /000/ {err=0}
{print $0}
END{
	if(NR > 0 && err == 1 ) {
		printf("%s: link search err. \134000 not found. sleep.\n", bf) > "/dev/stderr"
		for(;;){
			system("sleep 1000")
		}
	}
}' | sed -e 's/ 000/@/g' | tr -d '\n' | 
	tr ' ' '\134' | tr '@' '\n' | while read -r rlp_A
do
	# fname ... dir
	rlp_fin=`printf "$rlp_A"'@'`
	rlp_fin="${rlp_fin%?}"
	rlp_ftail=''	#file name only
	
	# kick err files
	if ! [ -e "$rlp_fin" ] ; then
#		echo "$0: link search err. file not found. '$rlp_fname'" > /dev/stderr
		printf '//%s\000' "$rlp_fin"
		continue
	fi
	
	# split dir + name. -f ... cant get ln, pipe etc.
	if ! [ -d "$rlp_fin" ] ; then		# -d ! not dir == files
	#	split dir + filename. and resolve soft link
	# ls --show-control-chars
	#	表示不可能な文字をそのまま表示 (プログラムが  'ls'  で  なかった
	#	り、出力が端末以外の場合は、これがデフォルト動作になる)
	#	...つまり、端末に表示せず変数等に代入する時は正確なファイル名が取得できるはず。

	#	-Lオプションはサイズや日付データのみでファイル名は対象外

		rlp_fname="$rlp_fin"
		#	normalize filename to have dir data	(aaa.txt -> ./aaa.txt etc)
		if [ "${rlp_fname#*/}" = "$rlp_fname" ] ; then
			rlp_fname='./'"$rlp_fname"
		fi

		while :		# recheck for multiple link (a -> b -> c etc)
		do

		if ! [ -h "$rlp_fname" ] ; then		# -h ... exist & link
			break
		fi


# 2-clause BSD license
# https://sites.google.com/site/jdisnard/realpath
# use 'ls -l' to get link-dst infomation.
# '->' use as string spliter	... http://pubs.opengroup.org/onlinepubs/9699919799/utilities/ls.html
# need LANG=c ? safety?
#	rlp_LANGbk="$LANG"
#	LANG="c"
		rlp_base=`/bin/ls -l "$rlp_fname" ; printf @`	# $() removes end '\n' (posix)
		rlp_base="${rlp_base%??}"	# aaa\n@ -> aaa	... ls add \n (like echo)
		rlp_count=`printf '%s' "$rlp_fname" | tr -c '>-' ' ' |
			sed -e 's/->/@/g' | tr -d -c '@' | wc -c`	# check '->' string(filename, username etc)
		rlp_count=$((rlp_count+1))
		
		for ii in `seq 1 $rlp_count `
		do
			rlp_base="${rlp_base#*->}"
		done
		rlp_fname='/'"${rlp_base#*/}"	# remove head ' '	ls disp filename

		done
		
		# if files, rlp_ftail != '', 
		rlp_ftail="${rlp_fname##*/}"	# filename only
		rlp_fdir="${rlp_fname%/*}"	# dirname only
	else
		# fin is dir.
		flp_fdir="$rlp_fin"
	fi
	
	# normalized. check path reallink
	# pwd -P: get full realpath. posix. (2001-?)
	# echo @ ... command substitution deletes lineend '\n, \n\n ...'.
	# http://pubs.opengroup.org/onlinepubs/9699919799/utilities/V3_chap02.html#tag_18_06_03
	# pwd permission... dir exec may make some problem. run at subshell.
	
	(
	for ii in skip		# jump emulate
	do
		cd "$rlp_fdir"
		if [ "$?" = "1" ] ; then
			echo "$0: link search err. dir access failed" > /dev/stderr
			printf '//%s\000' "$rlp_fdir"
			break
		fi		
		
		rlp_fpath=`pwd -P; printf '@'`
		if [ "$rlp_fpath" = '@' ] && [ "$err" != "" ] ; then
			echo "$0: link search err. pwd failed" > /dev/stderr
			printf '//%s\000' "$rlp_fdir"
			break
		fi
		
		rlp_fpath=${rlp_fpath%??}	# aaa\n@ -> aaa	... pwd add \n (like echo)
		rlp_fpath=${rlp_fpath%/}	# if aaa/ -> aaa etc
		rlp_fname="$rlp_fpath"'/'"$rlp_ftail"	# dir has end '/' ... 'aaa/' etc
		printf '%s\000' "$rlp_fname"
	done
	)
done | od -An -to1 -w16 -v | tr -d '\n' |
sed -e 's# 000#@#g' | tr ' ' '\134' | tr '@' '\n' | awk -v name="$0" '
	$0 ~ /^.057.057/ {
		gsub(/^.057.057/, "", $0)
		cmd="printf \047" $0 "\012\047 >/dev/stderr"
		printf "%s: link check err. file not found: ", name > "/dev/stderr"
		system(cmd)
		printf "//"
		}
	{print $0}'
)
}

fpath=$(printf `func_rlp "$0"`'@')
fpath=${fpath%?}
fname=`basename "$fpath"`
fdir=${fpath%/*}'/'
cd "$fdir"

#echo unkokko >/dev/stderr
#echo "$fdir" >/dev/stderr
#echo "$fpath" >/dev/stderr
#pwd >/dev/stderr
#exit

buf=`sh ./rdopt ":hi" "$@"`
if [ $? -ne 0 ] ; then echo "optErr see -h"; exit 1; fi
eval "$buf"

#------
if [ "$opt_h" = "1" ] ; then
cat << 'EEE'
HowTo (urdic.sh, your dictionary. bourne-shell + tcl/tk + java)
opt: -h, -i(nitialize)
------
0.) install: Extract(unzip) files (maybe already done)
    uninst: del top folder (portable. It’s an ill bird that fouls its own nest)

1.) ~$ ./urdic.sh -i
	>>	add executable (chmod 777 ***.sh ) to sub-pg.(sh-script)
		and make folders, check depends app.
2.) ~$ ./urdic.sh  ...or... nohup tsocks ./urdic.sh > /dev/null 2>&1 &
	>>  run

---abstract:
検: search word from dic(./mydic/mydic.txt)
	if not found, search word from web and add to dic
	automatically if 'web+保存' checked
	
貼: input selection string. (input 'highlight' word)
	*** PAY ATTENTION *** to clipboard data.(password, privacy etc...)

滅: remove word from dic
編: edit dic word and save.(検:apple -> add text '赤い' -> 編 )
音: playback word sound if files exists at ./mydic/sound/
...you can direct edit 'mydic.txt' and 'sound files'. 

...if your network uses proxy, set proxy warpper.
ex.) ./urdic.sh	-> blocked by proxy
ex.) tsocks ./urdic.sh	-> pass proxy

---logic:
search (searchdic.sh)  -y->	disp text.
  |
  +-n-> web_ok?  -y-> getdic.sh(wget, sed, parseHTML) -> adddic.sh
           |
           +-n-> end

del (deldic.sh) -> end
edit -> deldic.sh -> adddic.sh -> end
sound(sounddic.sh) -> end
...parseHTML, suckhtml.java. see ' ~$ java suckhtml -h'
EEE
exit 0
fi

if [ "$opt_i" = "1" ] ; then

	if ! [ -d "mydic" ] ; then
		mkdir mydic
	fi
	if ! [ -d "mydic/sound" ] ; then
		mkdir mydic/sound
	fi

	chmod 777 *.sh
	echo "---run: chmod 777 *.sh, mkdir 'dic'"
	echo "---check depends app."
	java -version 2>&1 | head -n 1
	echo "...need java 1.5 or upper. if re-build: 'javac (-target 1.5 -source 1.5) *.java'"
	wget --version | head -n 1
	sed --version | head -n 1
	vlc --version 2>&1 | head -n 1
	echo exit | wish
	echo "check 'echo exit | wish' status(0:good) ... $?"
	echo exit | wish8.6
	echo "check 'echo exit | wish8.6' status(0:good) ... $?"
	echo exit | tclsh
	echo "check 'echo exit | tclsh' status(0:good) ... $?"
	echo exit | tclsh8.6
	echo "check 'echo exit | tclsh8.6' status(0:good) ... $?"
	
	echo "---if some err, install package(apt, yum etc)"
	echo "---tcl/tk 10MB, vlc 30-50MB, java 60MB(JRE)-200MB(JDK), wget+sed 1MB"
	echo ""
	echo "...vlc, you can use other player. see & edit 'sounddic.sh'"
	echo "...tclsh/tk/wish is difficult to search (apt-cache search tcl tcl8.6 tk tk8.6)"
	echo "tcl(general name) ->  ~$ tclsh or tclsh8.6 (run comm)"
	echo "tk(general name, tcl plug-in) ->  ~$ wish or wish8.6 (run comm)"
	exit 0
fi

if [ "$#" = "0" ] ; then
# http://www.freesoftnet.co.jp/webfiles/tclkits/doc/TclCmdRef/UserCmd/tclsh_jp.htm
wish urdic.wish
fi
