#include <windows.h>
#include <vector>
#include <string>

namespace{
	bool wc_initialized = false;
	bool want_to_exit_loop = false;
}

struct DlgParameterInput_Result{
	std::vector<std::string> param_values;
};

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam){
    switch (msg) {
		case WM_COMMAND:
			if (LOWORD(wParam) == 1){
				want_to_exit_loop = true;
			}
			break;

        default:
            return(DefWindowProc(hWnd, msg, wParam, lParam));
    }
    return 0;
}

#define CLSNAME "DlgParamterInput"

DlgParameterInput_Result *DlgParameterInput_Show(int num_params, char *title, char *param_names[], char *param_surfixes[]){

	want_to_exit_loop = false;
	HWND hWnd;

	std::vector<HWND> param_edit_wnds;
	{
		WNDCLASSA wc = {0};
		HMODULE hInstance = ::GetModuleHandle(0);
		if (!wc_initialized) {
			wc.style         = CS_HREDRAW | CS_VREDRAW;
			wc.lpfnWndProc   = WndProc;
			wc.cbClsExtra    = 0;
			wc.cbWndExtra    = 0;
			wc.hInstance     = hInstance;
			wc.hIcon         = NULL;
			wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
			wc.hbrBackground = reinterpret_cast<HBRUSH>(COLOR_BACKGROUND);
//			wc.hbrBackground = static_cast<HBRUSH>(GetStockObject(NULL_BRUSH));
			wc.lpszMenuName  = NULL;
			wc.lpszClassName = CLSNAME;
			if (!RegisterClassA(&wc)) return NULL;
			wc_initialized = true;
		}

		// EBhE̐@
		int name_label_width = 200;
		int param_edit_width = 200;
		int okbutton_width = 100;
		int suffix_label_width = 50;
		int control_height = 24;
		int margin_x = 10;
		int margin_y = 10;
		int window_width = margin_x + name_label_width + margin_x + param_edit_width + margin_x + suffix_label_width + margin_x;
		int window_height = margin_y * (num_params + 2) + control_height * (num_params + 1);

		RECT rc;
		rc.left = 0;
		rc.top = 0;
		rc.right = window_width;
		rc.bottom = window_height;
		AdjustWindowRectEx(&rc, WS_CAPTION, FALSE, WS_EX_TOPMOST);

		// x[X̃EBhE쐬B
		hWnd = CreateWindowExA(WS_EX_TOPMOST, CLSNAME, title, WS_CAPTION,
			CW_USEDEFAULT, CW_USEDEFAULT, rc.right - rc.left, rc.bottom - rc.top,
			NULL, NULL, hInstance, NULL
		);

		int wx = 0, wy = 0;
		// p[^Lڂ郉xEBhE쐬B
		wx = margin_x;
		wy = margin_y;
		for (int i = 0; i < num_params; i++){
			HWND hLabel = CreateWindowA("STATIC", param_names[i], WS_CHILD | WS_VISIBLE,
				wx, wy, name_label_width, control_height, hWnd, 0, hInstance, NULL);
			wy += control_height + margin_y;
		}

		// p[^l͗pGfBbgEBhE쐬B
		wx = margin_x + name_label_width + margin_x;
		wy = margin_y;
		for (int i = 0; i < num_params; i++){
			HWND hEdit = CreateWindowExA(WS_EX_CLIENTEDGE, "EDIT", "", WS_CHILD | WS_VISIBLE | WS_BORDER,
				wx, wy, param_edit_width, control_height, hWnd, 0, hInstance, NULL);
			wy += control_height + margin_y;

			param_edit_wnds.push_back(hEdit);
		}

		// p[^̃TtBbNXLڂ郉xEBhE쐬B
		wx = margin_x + name_label_width + margin_x + param_edit_width + margin_x, wy = margin_y;
		for (int i = 0; i < num_params; i++){
			if (param_surfixes[i][0] != '\0'){
				HWND hLabel = CreateWindowA("STATIC", param_surfixes[i], WS_CHILD | WS_VISIBLE,
					wx, wy, suffix_label_width, control_height, hWnd, 0, hInstance, NULL);
			}
			wy += control_height + margin_y;
		}

		// OK{^쐬B
		wx = window_width - margin_x - okbutton_width;
		wy = window_height - margin_y - control_height;

		HWND hButton = CreateWindowA("BUTTON", "OK", WS_CHILD | WS_VISIBLE,
			wx, wy, okbutton_width, control_height, hWnd, reinterpret_cast<HMENU>(1), hInstance, NULL);

	}

	// ׂďÎŁAx[XEBhE\B
	ShowWindow(hWnd, SW_SHOW);

	// bZ[W[v(p[^̓EBhEւ̓͂AOK{^܂ő҂)B
	MSG msg;
	for(;;){
		if (PeekMessage (&msg,NULL,0,0,PM_REMOVE)) {
			if (msg.hwnd != hWnd && GetParent(msg.hwnd) != hWnd && msg.message != WM_PAINT) continue;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}else{
			if (!IsWindow(hWnd) || want_to_exit_loop) break;
			Sleep(10);
		}
	}
	want_to_exit_loop = false;

	DlgParameterInput_Result *this_ = new DlgParameterInput_Result();
	for (size_t i = 0; i < param_edit_wnds.size(); i++){
		HWND hEdit = param_edit_wnds[i];
		char buf[200] = {0};
		GetWindowTextA(hEdit, buf, 199);
		this_->param_values.push_back(buf);
	}
	DestroyWindow(hWnd);

	return this_;

ERR:
	return 0;
}

int GetItemCount(DlgParameterInput_Result *result){
	return static_cast<int>(result->param_values.size());
}

const char *GetItem(DlgParameterInput_Result *result, int idx){
	if (idx < 0 || idx >= static_cast<int>(result->param_values.size())) return NULL;
	return result->param_values[idx].c_str();
}

void Destroy(DlgParameterInput_Result *result){
	delete result;
}

