package org.dyndns.nuda.dynamic.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

import javax.tools.SimpleJavaFileObject;

/**
 * Javaバイトコードをあらわすクラスです
 * 
 * @author nkoseki
 * 
 */
public class JavaClassObject extends SimpleJavaFileObject {
	public JavaClassObject(final String name, final Kind kind) {
		super(URI.create(new StringBuilder().append("string:///")
				.append(name.replace(".", "/")).append(kind.extension)
				.toString()), kind);
	}
	
	protected final ByteArrayOutputStream	bos	= new ByteArrayOutputStream();
	
	@Override
	public OutputStream openOutputStream() throws IOException {
		return this.bos;
	}
	
	/**
	 * コンパイルされたバイトコードを取得します
	 * 
	 * @return コンパイル済みバイトコード
	 */
	public byte[] getBytes() {
		return this.bos.toByteArray();
	}
	
	/**
	 * ロードされたクラス
	 */
	private Class<?>	clazz	= null;
	
	/**
	 * 定義済みクラスを設定します
	 * 
	 * @param c
	 */
	public void setDefinedClass(final Class<?> c) {
		this.clazz = c;
	}
	
	/**
	 * 定義済みクラスを取得します
	 * 
	 * @return 定義済みクラスオブジェクト
	 */
	public Class<?> getDefinedClass() {
		return this.clazz;
	}
}
