package com.xxxxxxx.drvpp.fw.common.log;

/**
 * ロガーファクトリ
 */
public class LoggerFactoryImpl implements LoggerFactory {
	/**
	 * シングルトン保持
	 */
	private static class LoggerFactoryImplHolder {
		/**
		 * インスタンス
		 */
		private static final LoggerFactoryImpl instance = new LoggerFactoryImpl();
	}
	
	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static LoggerFactory getInstance() {
		LoggerFactoryImplHolder.instance.init();
		return LoggerFactoryImplHolder.instance;
	}

	/**
	 * コンストラクタ.
	 */
	private LoggerFactoryImpl(){
		
	}
	
	/**
	 * 初期化.
	 */
	private void init(){

	}

	/* (non-Javadoc)
	 * @see com.xxxxxxx.drvpp.fw.common.log.LoggerFactory#getLogger(java.lang.Class)
	 */
	public Logger getLogger(Class clazz){
		LoggerLog4jImpl log = new LoggerLog4jImpl();
		log.init(clazz);

		return log;
	}
}
