package com.xxxxxxx.drvpp.fw.common.mybatis;

import java.io.IOException;
import java.io.Reader;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

import com.xxxxxxx.drvpp.fw.common.exception.FwRuntimeException;

/**
 * MyBatisセッションファクトリ
 */
public class MyBatisSessionFactory {
	/** リソース */
	private static String resource = "mybatis.xml";
	/** SQLセッションファクトリ */
	private SqlSessionFactory sqlSessionFactory;

	/**
	 * シングルトン保持
	 */
	private static class MyBatisSessionFactoryHolder {
		/**
		 * インスタンス
		 */
		private static final MyBatisSessionFactory instance = new MyBatisSessionFactory();
	}

	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static MyBatisSessionFactory getInstance() {
		MyBatisSessionFactoryHolder.instance.init();
		return MyBatisSessionFactoryHolder.instance;
	}

	/**
	 * リソース設定.
	 * @param name リソース名
	 */
	public static void setResourceName(String name){
		resource = name;
	}

	/**
	 * コンストラクタ.
	 */
	private MyBatisSessionFactory() {

	}

	/**
	 * 初期化.
	 */
	private void init() {
		Reader reader;
		try {
			reader = Resources.getResourceAsReader(resource);
			SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
			sqlSessionFactory = builder.build(reader);
		} catch (IOException e) {
			throw new FwRuntimeException(e);
		}
	}

	/**
	 * SQLセッション取得.
	 * @return SQLセッション
	 */
	public SqlSession openSession() {
		return sqlSessionFactory.openSession();
	}

	/**
	 * SQLセッションファクトリ取得.
	 * @return SQLセッションファクトリ
	 */
	public SqlSessionFactory getSqlSessionFactory() {
	    return sqlSessionFactory;
	}

	/**
	 * SQLセッションファクトリ設定.
	 * @param sqlSessionFactory SQLセッションファクトリ
	 */
	public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
	    this.sqlSessionFactory = sqlSessionFactory;
	}
}
