package com.xxxxxxx.drvpp.fw.common.util;

import java.util.List;
import java.util.Map;

/**
 * 設定.
 */
public class SettingImpl implements Setting {
	/** マップ */
	private Map<String, Object> map = null;
	
	/**
	 * コンストラクタ.
	 * @param map マップ
	 */
	public SettingImpl(Map<String, Object> map) {
		this.map = map;
	}
	
	/* (non-Javadoc)
	 * @see com.xxxxxxx.drvpp.fw.common.util.Setting#get(java.lang.String)
	 */
	public String get(String key){
		return (String)map.get(key);
	}

	/* (non-Javadoc)
	 * @see com.xxxxxxx.drvpp.fw.common.util.Setting#getInt(java.lang.String)
	 */
	public int getInt(String key){
		String value = get(key);
		return Integer.parseInt(value);
	}

	/* (non-Javadoc)
	 * @see com.xxxxxxx.drvpp.fw.common.util.Setting#getList(java.lang.String)
	 */
	public List<?> getList(String key){
		List<?> list = (List<?>)map.get(key);
		return list;
	}

	/* (non-Javadoc)
	 * @see com.xxxxxxx.drvpp.fw.common.util.Setting#getObject(java.lang.String)
	 */
	public Object getObject(String key){
		return map.get(key);
	}
}
