# Aya CGI Interface v0.1.0

Aya can be configured to understand certain file extensions as CGI scripts.
This is done in the configuration file using the `cgi-extensions` key.  The
protocol for handling these (aka, what you're reading now) is deliberately
simple and roughly based on usual CGI 1.1 spec.

When a client sends a request and the path component has one of the CGI
extensions at the very end, Aya will attempt to execute that file.  If the file
does not exist, is not executable, or exits with an exit code of anything other
than 0, a `40 Temporary Failure` response is sent.  Otherwise its output is sent
verbatim to the requesting client.

The CGI script's environment will have various variables set that are filled
with information from the client.  The `PATH` environment variable is also set
strictly according to the `cgi-path` key in the configuration file.  The
server's `PATH` is not inherited, and no other environment variables except
those listed below exist for the CGI process.

## Environment Variables

* **DOCUMENT_ROOT**: The server root path, equivalent to the `server-root` key in the config file.
* **GATEWAY_INTERFACE**: The name and version of the Aya CGI Interface.  This
    should be `ACGI`, a space, and then a syumantic version.
* **PATH_INFO**: The path component of the URI
* **PATH_TRANSLATED**: The path to the CGI script as the server sees it.
* **SCRIPT_FILENAME**: The filename of the CGI script
* **QUERY_STRING**: The query component of the URI.
* **REQUEST_FRAGMENT**: The request component of the URI.
* **SERVER_HOST**: The host component of the URI.
* **SERVER_PORT**: The port component of the URI.  The `listen-port` value will
    be inserted here if the URI did not have a port specified.
* **PATH**: Same as usual, the `PATH` as understood by the shell.

## Standard Input, Standard Output, and Standard Error

Nothing is passed to the CGI process on standard input.

The CGI process is expected to produce a valid Gemini response header (and
corresponding body, if applicable) on standard output.  This will be sent
verbatim over the socket back to the requesting client.

If the CGI script encounters an error, it can be printed on standard error.  Any
output on this stream will be logged by Aya to its own standard error, as well
as any configured log file.
