#### Aya - A Gemini server
#### Copyright (C) 2021 Remilia Scarlet <remilia@posteo.jp>
####
#### This program is free software: you can redistribute it and/or modify
#### it under the terms of the GNU Affero General Public License as
#### published by the Free Software Foundation, either version 3 of the
#### License, or (at your option) any later version.
####
#### This program is distributed in the hope that it will be useful,
#### but WITHOUT ANY WARRANTY; without even the implied warranty of
#### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#### GNU Affero General Public License for more details.
####
#### You should have received a copy of the GNU Affero General Public License
#### along with this program.  If not, see <https://www.gnu.org/licenses/>.
require "openssl"

class OpenSSL::SSL::Socket::Server
  def rateLimitedCopy(limit : Int, source : IO)
    buf = Bytes.new(limit)
    numRead = 0
    start = Time.unix(0)
    finish = Time.unix(0)
    diff = Time::Span.new

    loop do
      numRead = source.read(buf)
      break if numRead <= 0

      start = Time.local
      self.write(buf[0...numRead])
      finish = Time.local
      diff = finish - start

      sleep (1000 - diff.total_milliseconds).milliseconds if diff.total_seconds < 1
    end
  end
end
